@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .preview{ height:120px; width:100%; max-width:320px; object-fit:cover; border-radius:12px; border:1px solid #e5e7eb; background:#f8fafc }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/banners') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-pen-to-square me-2"></i>Edit Banner #{{ $row->id }}</h5>
  </div>

  <form action="{{ url('/admin/banners/'.$row->id) }}" method="POST" enctype="multipart/form-data" class="card-edge p-3">
    @csrf @method('PUT')

    @if ($errors->any())
      <div class="alert alert-danger"><ul class="mb-0">@foreach ($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul></div>
    @endif

    <div class="row g-3">
      {{-- <div class="col-md-6">
        <label class="form-label">Image URL (optional)</label>
        <input name="image_path" class="form-control" value="{{ old('image_path',$row->image_path) }}" placeholder="https://...">
        <div class="form-text">ফাইল আপলোড দিলে এটি ইগনোর হবে।</div>
      </div> --}}
      <div class="col-md-12">
        <label class="form-label">Upload Image</label>
        <input type="file" id="imageFile" name="image_file" class="form-control" accept="image/*">
        @php
          $p = $row->image_path;
          $isStored = $p && \Illuminate\Support\Facades\Storage::disk('public')->exists($p);
          $isUrl    = $p && \Illuminate\Support\Str::startsWith($p,['http://','https://']);
          $src      = $isStored ? asset('storage/'.$p) : ($isUrl ? $p : null);
        @endphp
        @if($src)
          <img id="imgPreview" class="preview mt-2" src="{{ $src }}" alt="current">
        @else
          <img id="imgPreview" class="preview mt-2 d-none" src="#" alt="preview">
        @endif

        <div class="form-check mt-2">
          <input class="form-check-input" type="checkbox" name="remove_img" value="1" id="removeImg">
          <label class="form-check-label" for="removeImg">Remove stored image</label>
        </div>
      </div>

      <div class="col-md-3">
        <label class="form-label">Active *</label>
        <select name="is_active" class="form-select">
          <option value="1" @selected(old('is_active',$row->is_active)==1)>Active</option>
          <option value="0" @selected(old('is_active',$row->is_active)==0)>Inactive</option>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">Sort Order</label>
        <input type="number" name="sort_order" class="form-control" value="{{ old('sort_order',$row->sort_order) }}" min="0">
      </div>
    </div>

    <div class="d-flex gap-2 flex-wrap mt-3">
      <button class="btn btn-primary btn-wide"><i class="fa-regular fa-circle-check me-1"></i> Update</button>
      <a class="btn btn-outline-secondary btn-wide" href="{{ url('/admin/banners') }}">Back</a>
    </div>
  </form>
</div>

<script>
  document.getElementById('imageFile')?.addEventListener('change', e=>{
    const f = e.target.files?.[0]; if(!f) return;
    const url = URL.createObjectURL(f);
    const img = document.getElementById('imgPreview');
    img.src = url; img.classList.remove('d-none');
  });
</script>
@endsection
