@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .logo-56{ height:56px; width:56px; border-radius:50%; border:1px solid #e5e7eb; background:#fff; object-fit:contain; padding:6px }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray{ background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red{ background:#fee2e2; color:#991b1b }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/banks') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-rectangle-list me-2"></i>Bank Details</h5>
  </div>

  <div class="card-edge p-3">
    <div class="d-flex align-items-center gap-3">
      @php
        $p = $bank->logo_path;
        $isStored = $p && \Illuminate\Support\Facades\Storage::disk('public')->exists($p);
        $isUrl    = $p && \Illuminate\Support\Str::startsWith($p,['http://','https://']);
      @endphp

      @if($isStored)
        <img class="logo-56" src="{{ asset('storage/'.$p) }}" alt="">
      @elseif($isUrl)
        <img class="logo-56" src="{{ $p }}" alt="">
      @elseif($p)
        <div class="logo-56 d-flex align-items-center justify-content-center" style="font-size:22px;border-style:dashed">{{ $p }}</div>
      @else
        <span class="badge-soft gray"><i class="fa-regular fa-image me-1"></i>No logo</span>
      @endif

      <div>
        <h5 class="mb-1">{{ $bank->name }}</h5>
        <div class="d-flex flex-wrap gap-2">
          <span class="badge-soft gray">Slug: {{ $bank->slug }}</span>
          <span class="badge-soft {{ $bank->is_active ? 'green' : 'red' }}">
            <i class="fa-solid {{ $bank->is_active ? 'fa-toggle-on' : 'fa-toggle-off' }} me-1"></i>{{ $bank->is_active ? 'Active' : 'Inactive' }}
          </span>
        </div>
      </div>
    </div>

    <hr>

    <div class="row g-3">
      <div class="col-md-4">
        <div class="text-muted small mb-1">Min Transaction</div>
        <div class="fw-semibold">৳{{ number_format($bank->min_transaction,2) }}</div>
      </div>
      <div class="col-md-4">
        <div class="text-muted small mb-1">Reward Percent</div>
        <div class="fw-semibold">{{ number_format($bank->reward_percent,2) }}%</div>
      </div>
    </div>

    <div class="mt-3 d-flex gap-2 flex-wrap">
      <a class="btn btn-primary btn-wide" href="{{ url('/admin/banks/'.$bank->id.'/edit') }}">
        <i class="fa-regular fa-pen-to-square me-1"></i> Edit
      </a>
      <form action="{{ url('/admin/banks/'.$bank->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
        @csrf @method('DELETE')
        <button class="btn btn-outline-danger btn-wide"><i class="fa-regular fa-trash-can me-1"></i> Delete</button>
      </form>
    </div>
  </div>
</div>
@endsection
