@extends('backend.master')
@section('content')
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .section-title{ font-size:.95rem; font-weight:700; color:#334155 }
    .logo-preview{ height:56px; width:56px; border-radius:50%; object-fit:contain; border:1px solid #e5e7eb; background:#fff; padding:6px }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="{{ url('/admin/banks') }}" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-pen-to-square me-2"></i>Edit: {{ $bank->name }}</h5>
  </div>

  <form action="{{ url('/admin/banks/'.$bank->id) }}" method="POST" enctype="multipart/form-data" class="card-edge p-3">
    @csrf @method('PUT')

    @if ($errors->any())
      <div class="alert alert-danger"><ul class="mb-0">@foreach ($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul></div>
    @endif

    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Name *</label>
        <input name="name" class="form-control" value="{{ old('name',$bank->name) }}" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Slug (optional)</label>
        <input name="slug" class="form-control" value="{{ old('slug',$bank->slug) }}" placeholder="auto if empty">
      </div>
      <div class="col-md-4">
        <label class="form-label">Min Transaction (৳) *</label>
        <input type="number" step="0.01" name="min_transaction" class="form-control" value="{{ old('min_transaction',$bank->min_transaction) }}" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Reward Percent (%) *</label>
        <input type="number" step="0.01" name="reward_percent" class="form-control" value="{{ old('reward_percent',$bank->reward_percent) }}" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Active *</label>
        <select name="is_active" class="form-select">
          <option value="1" @selected(old('is_active',$bank->is_active)==1)>Active</option>
          <option value="0" @selected(old('is_active',$bank->is_active)==0)>Inactive</option>
        </select>
      </div>
    </div>

    <div class="section-title mb-2"><i class="fa-regular fa-image me-1"></i> Logo</div>
    <div class="row g-3 mb-3">
      {{-- <div class="col-md-6">
        <label class="form-label">Logo URL / Emoji / Text</label>
        <input name="logo_path" class="form-control" value="{{ old('logo_path',$bank->logo_path) }}" placeholder="https://... or 🏦">
        <div class="form-text">ফাইল দিলে এটি ইগনোর হবে।</div>
      </div> --}}
      <div class="col-md-12">
        <label class="form-label">Upload Image</label>
        <input type="file" id="logoFile" name="logo_file" class="form-control" accept="image/*">
        <div class="d-flex align-items-center gap-3 mt-2">
          @php
            $p = $bank->logo_path;
            $isStored = $p && \Illuminate\Support\Facades\Storage::disk('public')->exists($p);
            $isUrl    = $p && \Illuminate\Support\Str::startsWith($p,['http://','https://']);
          @endphp
          @if($isStored)
            <img id="logoPreview" class="logo-preview" src="{{ asset('storage/'.$p) }}" alt="current">
          @elseif($isUrl)
            <img id="logoPreview" class="logo-preview" src="{{ $p }}" alt="current">
          @else
            <img id="logoPreview" class="logo-preview d-none" src="#" alt="preview">
          @endif

          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="remove_logo" value="1" id="removeLogo">
            <label class="form-check-label" for="removeLogo">Remove stored logo</label>
          </div>
        </div>
      </div>
    </div>

    <div class="d-flex gap-2 flex-wrap">
      <button class="btn btn-primary btn-wide"><i class="fa-regular fa-circle-check me-1"></i> Update</button>
      <a class="btn btn-outline-secondary btn-wide" href="{{ url('/admin/banks') }}">Back</a>
    </div>
  </form>
</div>

<script>
  document.getElementById('logoFile')?.addEventListener('change', e=>{
    const f = e.target.files?.[0]; if(!f) return;
    const url = URL.createObjectURL(f);
    const img = document.getElementById('logoPreview');
    img.src = url; img.classList.remove('d-none');
  });
</script>
@endsection
