@extends('backend.master')

@section('content')
<div class="container-fluid py-3">

    <div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
        <h5 class="mb-0"><i class="fa-regular fa-credit-card me-1"></i> Add Money Cards</h5>
        <a href="{{ route('admin.add-money-cards.create') }}" class="btn btn-success">
            <i class="fa-solid fa-plus me-1"></i> Add New Card
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success py-2">{{ session('success') }}</div>
    @endif

    <form class="mb-3 d-flex flex-wrap gap-2" method="GET" action="{{ route('admin.add-money-cards.index') }}">
        <input type="text"
               name="search"
               value="{{ request('search') }}"
               class="form-control"
               placeholder="Search brand / holder name / card number">
        <button class="btn btn-outline-secondary">
            <i class="fa-solid fa-magnifying-glass"></i>
        </button>
    </form>

    <div class="card">
        <div class="table-responsive">
            <table class="table table-striped align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Logo</th>
                        <th>Brand</th>
                        <th>Holder Name</th>
                        <th>Card Number</th>
                        <th>Expire</th>
                        <th>Status</th>
                        <th class="text-end">Actions</th>
                    </tr>
                </thead>
                <tbody>
                @forelse($cards as $card)
                    <tr>
                        <td>{{ $card->id }}</td>
                        <td>
                            @if($card->logo)
                                <img src="{{ asset('storage/' . $card->logo) }}"
                                     style="width:40px;height:26px;object-fit:contain;"
                                     alt="">
                            @else
                                <span class="text-muted">No logo</span>
                            @endif
                        </td>
                        <td>{{ $card->brand }}</td>
                        <td>{{ $card->holder_name }}</td>
                        <td>
                            <span class="text-monospace">
                                {{ Str::limit($card->card_number, 8, '••••') }}
                            </span>
                        </td>
                        <td>{{ $card->expire_date }}</td>
                        <td>
                            @if($card->is_active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td class="text-end">
                            <a href="{{ route('admin.add-money-cards.edit', $card) }}"
                               class="btn btn-sm btn-outline-info">
                                <i class="fa-regular fa-pen-to-square"></i>
                            </a>

                            <form action="{{ route('admin.add-money-cards.destroy', $card) }}"
                                  method="POST"
                                  class="d-inline"
                                  onsubmit="return confirm('Delete this card?');">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-outline-danger">
                                    <i class="fa-regular fa-trash-can"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">
                            No cards found.
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>

        <div class="card-footer">
            {{ $cards->links() }}
        </div>
    </div>
</div>
@endsection
