@extends('backend.master')

@section('content')
<div class="container-fluid py-3">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">Edit Card #{{ $card->id }}</h5>
        <a href="{{ route('admin.add-money-cards.index') }}" class="btn btn-outline-secondary">
            <i class="fa-solid fa-arrow-left"></i> Back
        </a>
    </div>

    <div class="card">
        <div class="card-body">

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('admin.add-money-cards.update', $card) }}"
                  method="POST"
                  enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Card Number</label>
                        <input type="text" name="card_number" class="form-control"
                               value="{{ old('card_number', $card->card_number) }}" required>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Expire Date (MM/YY)</label>
                        <input type="text" name="expire_date" class="form-control"
                               value="{{ old('expire_date', $card->expire_date) }}" required>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">CVV</label>
                        <input type="text" name="cvv" class="form-control"
                               value="{{ old('cvv', $card->cvv) }}" required>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Card Holder Name</label>
                        <input type="text" name="holder_name" class="form-control"
                               value="{{ old('holder_name', $card->holder_name) }}" required>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Brand</label>
                        <input type="text" name="brand" class="form-control"
                               value="{{ old('brand', $card->brand) }}" required>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Slug (optional)</label>
                        <input type="text" name="slug" class="form-control"
                               value="{{ old('slug', $card->slug) }}"
                               placeholder="auto-generate if empty">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Logo (optional)</label>
                        <input type="file" name="logo" class="form-control" accept="image/*">
                        @if($card->logo)
                            <div class="mt-2">
                                <small class="text-muted d-block">Current logo:</small>
                                <img src="{{ asset('storage/' . $card->logo) }}"
                                     style="width:80px;height:50px;object-fit:contain;" alt="">
                            </div>
                        @endif
                    </div>

                    <div class="col-md-4">
                        <div class="form-check mt-4">
                            <input type="checkbox" name="is_active" value="1"
                                   class="form-check-input"
                                   id="is_active"
                                   {{ old('is_active', $card->is_active) ? 'checked' : '' }}>
                            <label for="is_active" class="form-check-label">Active</label>
                        </div>
                    </div>
                </div>

                <div class="mt-4">
                    <button class="btn btn-success">
                        <i class="fa-solid fa-save me-1"></i> Update Card
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
