<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login - PIN</title>
    <link rel="stylesheet"
          href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <style>
        .pin-input {
            letter-spacing: 10px;
            text-align: center;
            font-size: 22px;
        }
    </style>
</head>
<body class="bg-light">

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-4">

            <div class="card shadow-sm">
                <div class="card-header text-center">
                    <h5 class="mb-0">Enter PIN (Step 3)</h5>
                </div>
                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger py-2">
                            <ul class="mb-0" style="font-size: 13px;">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <p class="text-muted" style="font-size: 13px;">
                        Enter your 4 digit login PIN to continue to dashboard.
                    </p>

                    <form method="POST" action="{{ route('phone.login.pin.submit') }}">
                        @csrf

                        <div class="mb-3">
                            <label for="pin" class="form-label">PIN</label>
                            <input id="pin" type="password"
                                   class="form-control pin-input @error('pin') is-invalid @enderror"
                                   name="pin"
                                   maxlength="4"
                                   inputmode="numeric"
                                   required>
                        </div>

                        <button type="submit" class="btn btn-primary w-100">
                            Login to Dashboard
                        </button>
                    </form>

                </div>
            </div>

        </div>
    </div>
</div>

<script>
    // শুধু সংখ্যা allow করার জন্য (optional)
    const pinInput = document.getElementById('pin');
    if (pinInput) {
        pinInput.addEventListener('input', function () {
            this.value = this.value.replace(/\D/g, '').slice(0, 4);
        });
    }
</script>

</body>
</html>
