@extends('backend.master')
@section('title','Upload Apps')

@section('content')
<main class="mx-auto w-full max-w-[960px] p-4 mb-24">

  {{-- Top header --}}
  <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between mb-4">
    <div>
      <h1 class="text-base sm:text-lg font-extrabold text-slate-800">Upload Apps</h1>
      <p class="text-[11px] sm:text-xs text-slate-500 mt-1">Manage your uploaded app files.</p>
    </div>
    <a style="color: #000!important;" href="{{ route('upload-apps.create') }}"
       class="inline-flex items-center justify-center gap-2 rounded-2xl bg-gradient-to-r from-[#2FAAA6] to-[#1f8f8b]
              px-4 py-2 text-xs sm:text-sm font-semibold text-white shadow-lg hover:from-[#2FAAA6] hover:to-[#197c78]">
      <span>+ New Upload</span>
    </a>
  </div>

  {{-- Alerts --}}
  @if(session('success'))
    <div class="mb-4 rounded-2xl border border-emerald-200 bg-emerald-50 px-4 py-3 text-emerald-800 shadow-sm text-xs sm:text-sm">
      {{ session('success') }}
    </div>
  @endif

  {{-- Table wrapper (horizontal scroll on mobile) --}}
  <div class="overflow-x-auto">
    <div class="min-w-[480px] overflow-hidden rounded-2xl border border-slate-200 bg-white shadow-[0_22px_60px_-26px_rgba(2,6,23,.16)]">
      <table class="min-w-full text-xs sm:text-sm">
        <thead class="bg-slate-50 text-slate-600 text-[11px] sm:text-xs uppercase tracking-wide">
          <tr>
            <th class="px-3 sm:px-4 py-3 text-left">ID</th>
            <th class="px-3 sm:px-4 py-3 text-left">File</th>
            <th class="px-3 sm:px-4 py-3 text-left">Uploaded At</th>
            <th class="px-3 sm:px-4 py-3 text-right">Actions</th>
          </tr>
        </thead>
        <tbody>
          @forelse($apps as $app)
            <tr class="border-t border-slate-100 hover:bg-slate-50/60">
              <td class="px-3 sm:px-4 py-3 text-[11px] sm:text-xs text-slate-500">#{{ $app->id }}</td>
              <td class="px-3 sm:px-4 py-3">
                @if($app->upload_apk)
                  <a href="{{ asset('storage/'.$app->upload_apk) }}"
                     class="text-xs sm:text-sm font-medium text-[#1f8f8b] hover:underline break-all" target="_blank">
                    {{ basename($app->upload_apk) }}
                  </a>
                @else
                  <span class="text-[11px] text-slate-400">No file</span>
                @endif
              </td>
              <td class="px-3 sm:px-4 py-3 text-[11px] sm:text-xs text-slate-500">
                {{ $app->created_at?->format('d M Y, h:i A') }}
              </td>
              <td class="px-3 sm:px-4 py-3">
                <div class="flex justify-end gap-2">
                  <a href="{{ route('upload-apps.edit',$app) }}"
                     class="inline-flex items-center rounded-xl border border-slate-200 bg-white px-3 py-1.5 text-[11px] sm:text-xs font-semibold text-slate-700 hover:bg-slate-50">
                    Edit
                  </a>
                  <form method="POST" action="{{ route('upload-apps.destroy',$app) }}"
                        onsubmit="return confirm('Delete this app?');">
                    @csrf
                    @method('DELETE')
                    <button
                      class="inline-flex items-center rounded-xl border border-rose-200 bg-rose-50 px-3 py-1.5 text-[11px] sm:text-xs font-semibold text-rose-700 hover:bg-rose-100">
                      Delete
                    </button>
                  </form>
                </div>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="4" class="px-4 py-6 text-center text-xs sm:text-sm text-slate-500">
                No uploads found.
              </td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>

  <div class="mt-4">
    {{ $apps->links() }}
  </div>
</main>
@endsection
