@extends('backend.master')
@section('title','New App Upload')

@section('content')
<main class="mx-auto w-full max-w-[640px] p-4 mb-24">

  <div class="mb-4 flex flex-col gap-2 sm:flex-row sm:items-center sm:justify-between">
    <div>
      <h1 class="text-base sm:text-lg font-extrabold text-slate-800">Upload New App</h1>
      <p class="text-[11px] sm:text-xs text-slate-500 mt-1">Choose an app file (APK/ZIP/etc) to upload.</p>
    </div>
    <a style="color: #000!important;" href="{{ route('upload-apps.index') }}"
       class="text-[11px] sm:text-xs font-semibold text-[#1f8f8b] hover:underline">
      ← Back to list
    </a>
  </div>

  @if($errors->any())
    <div class="mb-4 rounded-2xl border border-rose-200 bg-rose-50 px-4 py-3 text-rose-700 shadow-sm text-xs sm:text-sm">
      {{ implode(' ', $errors->all()) }}
    </div>
  @endif

  <section class="overflow-hidden rounded-2xl border border-slate-200 bg-white shadow-[0_22px_60px_-26px_rgba(2,6,23,.16)]">
    <div style="color: #000!important;" class="bg-gradient-to-r from-[#2FAAA6] to-[#1f8f8b] px-4 sm:px-5 py-3 text-xs sm:text-sm font-semibold text-white">
      App Upload Form
    </div>

    <div class="p-4 sm:p-5">
      <form method="POST" action="{{ route('upload-apps.store') }}" enctype="multipart/form-data" class="space-y-4">
        @csrf

        <label class="block">
          <span class="mb-1 block text-xs sm:text-sm font-medium text-slate-700">App File</span>
          <input
            type="file" name="upload_apk"
            class="mt-1 block w-full text-xs sm:text-sm text-slate-600
                   file:mr-4 file:rounded-xl file:border-0 file:bg-[#2FAAA6]/10 file:px-4 file:py-2 file:text-[#1f8f8b]
                   hover:file:bg-[#2FAAA6]/20">
          <span class="mt-1 block text-[11px] text-slate-500">Allowed: any app file (max 50MB)</span>
          @error('upload_apk') <span class="mt-1 block text-[11px] text-rose-600">{{ $message }}</span> @enderror
        </label>

        <button style="color: #000!important; background-color: yellow; padding: 10px 20px;"
          class="w-full rounded-2xl bg-gradient-to-r from-[#2FAAA6] to-[#1f8f8b] px-5 py-2.5 sm:py-3 text-center text-xs sm:text-sm font-semibold text-white
                 shadow-[0_26px_70px_-28px_rgba(47,170,166,.45)] hover:from-[#2FAAA6] hover:to-[#197c78]">
          Upload
        </button>
      </form>
    </div>
  </section>
</main>
@endsection
