@extends('backend.master')
@section('title','Transactions')

@section('content')
<div class="max-w-6xl mx-auto p-4 space-y-4">
    <h1 class="text-2xl font-bold mb-2">ট্রানজ্যাকশন</h1>

    <div class="bg-white rounded-2xl shadow overflow-x-auto">
        <table class="min-w-full text-sm">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-3 py-2 text-left">ID</th>
                    <th class="px-3 py-2 text-left">User</th>
                    <th class="px-3 py-2 text-left">Gateway</th>
                    <th class="px-3 py-2 text-left">Amount</th>
                    <th class="px-3 py-2 text-left">Commission</th>
                    <th class="px-3 py-2 text-left">Status</th>
                    <th class="px-3 py-2 text-left">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($transactions as $t)
                <tr class="border-t">
                    <td class="px-3 py-2">{{ $t->id }}</td>
                    <td class="px-3 py-2">{{ $t->user->name }}</td>
                    <td class="px-3 py-2">{{ $t->gateway->name }}</td>
                    <td class="px-3 py-2">{{ number_format($t->amount,2) }} ৳</td>
                    <td class="px-3 py-2">{{ number_format($t->commission_amount,2) }} ৳</td>
                    <td class="px-3 py-2">
                        <span class="px-2 py-1 rounded-full text-xs
                        @if($t->status=='approved') bg-emerald-50 text-emerald-700
                        @elseif($t->status=='rejected') bg-rose-50 text-rose-700
                        @else bg-amber-50 text-amber-700 @endif">
                        {{ $t->status }}
                        </span>
                    </td>
                    <td class="px-3 py-2">
                        @if($t->status=='pending')
                        <form action="{{ route('admin.transactions.approve',$t) }}" method="POST" class="inline">
                            @csrf
                            <button class="px-3 py-1 rounded bg-emerald-600 text-white">Approve</button>
                        </form>
                        <form action="{{ route('admin.transactions.reject',$t) }}" method="POST" class="inline">
                            @csrf
                            <button class="px-3 py-1 rounded bg-rose-600 text-white">Reject</button>
                        </form>
                        @else
                        <span class="text-gray-400">—</span>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        <div class="p-3">{{ $transactions->links() }}</div>
    </div>
</div>
@endsection
