<!doctype html>
<html lang="bn">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Deposit Settings</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="p-6 bg-slate-50">
  <div class="mx-auto max-w-3xl">
    <h1 class="mb-4 text-2xl font-bold">Deposit Page Settings</h1>

    @if(session('success'))
      <div class="mb-3 rounded border border-emerald-200 bg-emerald-50 p-3 text-emerald-800">{{ session('success') }}</div>
    @endif
    @if ($errors->any())
      <div class="mb-3 rounded border border-rose-200 bg-rose-50 p-3 text-rose-800">
        <ul class="list-disc pl-5">@foreach($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul>
      </div>
    @endif

    <form method="post" action="{{ route('admin.settings.deposit.update') }}" class="space-y-4 rounded-lg border bg-white p-4">
      @csrf
      <div class="grid grid-cols-2 gap-3">
        <label class="block">
          <span class="text-sm font-medium">Banner Title</span>
          <input name="deposit_banner_title" value="{{ old('deposit_banner_title',$data['deposit_banner_title']) }}" class="mt-1 w-full rounded border px-3 py-2" required>
        </label>
        <label class="block">
          <span class="text-sm font-medium">Banner Chip</span>
          <input name="deposit_banner_chip" value="{{ old('deposit_banner_chip',$data['deposit_banner_chip']) }}" class="mt-1 w-full rounded border px-3 py-2">
        </label>
      </div>

      <label class="block">
        <span class="text-sm font-medium">Banner Subtitle</span>
        <input name="deposit_banner_subtitle" value="{{ old('deposit_banner_subtitle',$data['deposit_banner_subtitle']) }}" class="mt-1 w-full rounded border px-3 py-2" required>
      </label>

      <label class="block">
        <span class="text-sm font-medium">Rules (Markdown/Plain)</span>
        <textarea name="deposit_rules_text" rows="5" class="mt-1 w-full rounded border px-3 py-2" required>{{ old('deposit_rules_text',$data['deposit_rules_text']) }}</textarea>
      </label>

      <div class="grid grid-cols-2 gap-3">
        <label class="block">
          <span class="text-sm font-medium">Contact Phone</span>
          <input name="contact_phone" value="{{ old('contact_phone',$data['contact_phone']) }}" class="mt-1 w-full rounded border px-3 py-2" required>
        </label>
        <label class="block">
          <span class="text-sm font-medium">Wallet/Provider</span>
          <input name="contact_provider" value="{{ old('contact_provider',$data['contact_provider']) }}" class="mt-1 w-full rounded border px-3 py-2" required>
        </label>
      </div>

      <div class="flex gap-2">
        <button class="rounded bg-teal-700 px-4 py-2 text-white">Save</button>
        <a href="{{ route('admin.packages.index') }}" class="rounded border px-4 py-2">Back</a>
      </div>
    </form>
  </div>
</body>
</html>
