@extends('backend.master')

@section('content')
<style>
  .wrap{padding:16px}
  .btn{display:inline-flex;align-items:center;gap:8px;padding:10px 14px;border-radius:10px;border:1px solid transparent;color:#fff;text-decoration:none}
  .btn-ghost{background:transparent;border-color:#e5e7eb;color:#0b1324}
  .btn-danger{background:linear-gradient(135deg,#ef4444,#dc2626)}
  .card{background:#fff;border:1px solid #e5e7eb;border-radius:16px;padding:16px;max-width:980px}
  dl{display:grid;grid-template-columns:220px 1fr;gap:10px;align-items:center}
  dt{font-weight:700;color:#0b1324}
  dd{margin:0;color:#0b1324}
  @media(max-width:640px){ dl{grid-template-columns:1fr} }
  .badge{padding:6px 10px;border-radius:999px;font-size:12px;font-weight:600;display:inline-flex;gap:6px;align-items:center}
  .badge-success{background:#ecfdf5;color:#065f46;border:1px solid #a7f3d0}
  .badge-muted{background:#f1f5f9;color:#334155;border:1px solid #e2e8f0}
  .actions{display:flex;gap:8px;flex-wrap:wrap;margin-top:12px}
</style>

<div class="wrap">
  <div class="actions">
    <a class="btn btn-ghost" href="{{ route('reward-settings.index') }}"><i class="fa-solid fa-arrow-left"></i> Back</a>
    <a class="btn btn-ghost" href="{{ route('reward-settings.edit', $rewardSetting) }}"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
    <form action="{{ route('reward-settings.destroy', $rewardSetting) }}" method="POST" onsubmit="return confirm('Delete this item?')">
      @csrf @method('DELETE')
      <button class="btn btn-danger" type="submit"><i class="fa-solid fa-trash"></i> Delete</button>
    </form>
  </div>

  <h1 style="margin:12px 0;display:flex;gap:10px;align-items:center">
    <i class="fa-solid fa-gift" style="color:#2563eb"></i> Reward Setting #{{ $rewardSetting->id }}
  </h1>

  <div class="card">
    <dl>
      <dt><i class="fa-solid fa-wallet"></i> Add Money Commission</dt>
      <dd>{{ number_format($rewardSetting->add_money_comm, 2) }}</dd>

      <dt><i class="fa-solid fa-paper-plane"></i> Send Money Commission</dt>
      <dd>{{ number_format($rewardSetting->send_money_comm, 2) }}</dd>

      <dt><i class="fa-solid fa-car"></i> Drive Offer Commission</dt>
      <dd>{{ number_format($rewardSetting->drive_offer_comm, 2) }}</dd>

      <dt><i class="fa-solid fa-bolt"></i> Mobile Recharge Commission</dt>
      <dd>{{ number_format($rewardSetting->mobile_recharge_comm, 2) }}</dd>

      <dt><i class="fa-solid fa-file-invoice-dollar"></i> Pay Bills Commission</dt>
      <dd>{{ number_format($rewardSetting->paybills_comm, 2) }}</dd>

      <dt><i class="fa-solid fa-mobile-screen-button"></i> Mobile Banking Commission</dt>
      <dd>{{ number_format($rewardSetting->mobile_banking_comm, 2) }}</dd>

      <dt><i class="fa-solid fa-building-columns"></i> Bank Transfer Commission</dt>
      <dd>{{ number_format($rewardSetting->bank_trans_comm, 2) }}</dd>

      <dt><i class="fa-solid fa-toggle-on"></i> Active</dt>
      <dd>
        @if($rewardSetting->is_active)
          <span class="badge badge-success"><i class="fa-solid fa-circle"></i> Active</span>
        @else
          <span class="badge badge-muted"><i class="fa-regular fa-circle"></i> Inactive</span>
        @endif
      </dd>

      <dt><i class="fa-regular fa-calendar-plus"></i> Created At</dt>
      <dd>{{ $rewardSetting->created_at }}</dd>

      <dt><i class="fa-regular fa-clock"></i> Updated At</dt>
      <dd>{{ $rewardSetting->updated_at }}</dd>
    </dl>
  </div>
</div>
@endsection
