@extends('backend.master')

@section('content')
<style>
  .wrap{padding:16px}
  .btn{display:inline-flex;align-items:center;gap:8px;padding:10px 14px;border-radius:10px;border:1px solid transparent;color:#fff;text-decoration:none}
  .btn-ghost{background:transparent;border-color:#e5e7eb;color:#0b1324}
  .btn-primary{background:linear-gradient(135deg,#3b82f6,#2563eb)}
  .grid{display:grid;grid-template-columns:repeat(2,minmax(0,1fr));gap:14px}
  @media(max-width:720px){ .grid{grid-template-columns:1fr} }
  .card{background:#fff;border:1px solid #e5e7eb;border-radius:16px;padding:16px;max-width:980px}
  label{font-weight:600;margin-bottom:6px;display:block;color:#0b1324}
  input[type="number"]{width:100%;padding:12px;border:1px solid #e5e7eb;border-radius:10px}
  .row{display:flex;flex-direction:column;gap:6px}
  .form-actions{display:flex;gap:10px;flex-wrap:wrap;margin-top:10px}
  small.err{color:#b91c1c}
  .switch{display:inline-flex;align-items:center;gap:8px;cursor:pointer}
  .switch input{accent-color:#22c55e;height:18px;width:18px}
</style>

<div class="wrap">
  <div style="margin-bottom:12px">
    <a class="btn btn-ghost" href="{{ route('reward-settings.index') }}"><i class="fa-solid fa-arrow-left"></i> Back</a>
  </div>

  <h1 style="margin:0 0 12px 0;display:flex;gap:10px;align-items:center">
    <i class="fa-solid fa-circle-plus" style="color:#2563eb"></i> Create Reward Setting
  </h1>

  <form action="{{ route('reward-settings.store') }}" method="POST" class="card">
    @csrf
    <div class="grid">
      @php
        $fields = [
          ['key'=>'add_money_comm','label'=>'Add Money Commission','icon'=>'fa-wallet'],
          ['key'=>'send_money_comm','label'=>'Send Money Commission','icon'=>'fa-paper-plane'],
          ['key'=>'drive_offer_comm','label'=>'Drive Offer Commission','icon'=>'fa-car'],
          ['key'=>'mobile_recharge_comm','label'=>'Mobile Recharge Commission','icon'=>'fa-bolt'],
          ['key'=>'paybills_comm','label'=>'Pay Bills Commission','icon'=>'fa-file-invoice-dollar'],
          ['key'=>'mobile_banking_comm','label'=>'Mobile Banking Commission','icon'=>'fa-mobile-screen-button'],
          ['key'=>'bank_trans_comm','label'=>'Bank Transfer Commission','icon'=>'fa-building-columns'],
        ];
      @endphp

      @foreach($fields as $f)
        <div class="row">
          <label for="{{ $f['key'] }}"><i class="fa-solid {{ $f['icon'] }}"></i> {{ $f['label'] }}</label>
          <input type="number" step="0.01" min="0" id="{{ $f['key'] }}" name="{{ $f['key'] }}" value="{{ old($f['key'], 0) }}" required>
          @error($f['key']) <small class="err">{{ $message }}</small> @enderror
        </div>
      @endforeach
    </div>

    <div style="margin-top:10px">
      <label class="switch">
        <input type="checkbox" name="is_active" id="is_active" {{ old('is_active', true) ? 'checked' : '' }}>
        <span>Active</span>
      </label>
    </div>

    <div class="form-actions">
      <a class="btn btn-ghost" href="{{ route('reward-settings.index') }}"><i class="fa-solid fa-xmark"></i> Cancel</a>
      <button class="btn btn-primary" type="submit"><i class="fa-solid fa-floppy-disk"></i> Save</button>
    </div>
  </form>
</div>
@endsection
