@extends('backend.master')

@push('styles')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
:root{ --gap:12px; --border:#e9ecef; --muted:#6c757d; }
.card{ border-radius:12px; } .card-header{ border-bottom:1px solid var(--border); }

/* Table */
.table thead th{ font-weight:600; text-transform:uppercase; font-size:12px; letter-spacing:.04em; border-bottom:2px solid var(--border)!important;}
.table td{ vertical-align:middle; }
.badge{ padding:.5em .65em; font-weight:600; }

/* Filters */
.filters-wrap{ display:grid; grid-template-columns:1fr auto; gap:var(--gap);}
.filters-title{ display:flex; align-items:center; gap:10px;}
.filter-toggle{ display:inline-flex; align-items:center; gap:8px; border:1px solid var(--border); border-radius:8px; padding:6px 10px; background:#fff; cursor:pointer;}
.filters{ grid-column:1/-1; display:grid; gap:var(--gap); background:#f8f9fa; border:1px solid var(--border); border-radius:10px; padding:10px; transition:max-height .25s ease, opacity .2s ease; overflow:hidden; max-height:0; opacity:0;}
.filters.open{ max-height:220px; opacity:1; }
.filters-grid{ display:grid; gap:var(--gap); }
.filters-grid .input-group-text{ background:#fff; }

/* Desktop */
@media (min-width:768px){
  .filters-wrap{ grid-template-columns:auto 1fr; }
  .filter-toggle{ display:none; }
  .filters{ grid-column:2/3; background:transparent; border:none; padding:0; max-height:none; opacity:1; overflow:visible; }
  .filters-grid{ grid-auto-flow:column; grid-auto-columns:max-content; align-items:center; gap:var(--gap); }
  .filters-grid .form-control{ width:300px; }
}

/* Buttons */
.btn-soft{ border:1px solid rgba(0,0,0,.08); background:#fff; box-shadow:0 1px 2px rgba(0,0,0,.04); }
.btn-soft:hover{ box-shadow:0 2px 6px rgba(0,0,0,.08); }

/* Helper */
.text-mono { font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; }
</style>
@endpush

@section('content')
<div class="container py-4">
  <div class="card shadow-sm border-0">
    <div class="card-header bg-white">
      <div class="filters-wrap">
        <h5 class="filters-title mb-0">
          <i class="fa-solid fa-gift me-2"></i> Reward Conversions
        </h5>

        <button type="button" class="filter-toggle" id="filterToggle" aria-expanded="false" aria-controls="filters">
          <i class="fa-solid fa-filter"></i> Filters
        </button>

        <form id="filters" method="get" class="filters {{ request()->filled('q') ? 'open' : '' }}">
          <div class="filters-grid">
            <div class="input-group input-group-sm">
              <span class="input-group-text"><i class="fa-solid fa-magnifying-glass"></i></span>
              <input type="text" name="q" class="form-control" value="{{ request('q') }}" placeholder="Search by user / reference">
            </div>

            <button class="btn btn-sm btn-primary" type="submit">
              <i class="fa-solid fa-filter me-1"></i>
              <span class="d-none d-md-inline">Apply</span><span class="d-md-none">Go</span>
            </button>

            @if(request()->filled('q'))
            <a href="{{ route('admin.reward_conversions.index') }}" class="btn btn-sm btn-soft">
              <i class="fa-solid fa-rotate-left me-1"></i> Reset
            </a>
            @endif
          </div>
        </form>
      </div>
    </div>

    <div class="card-body">
      @if(session('ok'))
        <div class="alert alert-success mb-3">
          <i class="fa-solid fa-circle-check me-1"></i>{{ session('ok') }}
        </div>
      @endif
      @if ($errors->any())
        <div class="alert alert-danger mb-3">
          <strong><i class="fa-solid fa-triangle-exclamation me-1"></i>Validation error:</strong>
          <ul class="mb-0">@foreach ($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul>
        </div>
      @endif

      <div class="table-responsive">
        <table class="table align-middle">
          <thead>
            <tr>
              <th>#</th>
              <th>User</th>
              <th>Points</th>
              <th>Rate</th>
              <th>Amount</th>
              <th>Ref</th>
              <th>Created</th>
              <th class="text-end">Actions</th>
            </tr>
          </thead>
          <tbody>
          @forelse($conversions as $c)
            <tr>
              <td class="text-muted">#{{ $c->id }}</td>
              <td><i class="fa-solid fa-user me-1 text-muted"></i>{{ $c->user?->name }}</td>
              <td><i class="fa-solid fa-star me-1 text-muted"></i>{{ number_format($c->points) }}</td>
              <td class="text-mono">{{ $c->rate_points }} : {{ number_format($c->rate_amount, 2) }}</td>
              <td><i class="fa-solid fa-bangladeshi-taka-sign me-1 text-muted"></i>{{ number_format($c->amount, 2) }}</td>
              <td class="text-mono">{{ $c->ref }}</td>
              <td><i class="fa-regular fa-clock me-1 text-muted"></i>{{ $c->created_at?->format('Y-m-d H:i') }}</td>
              <td class="text-end">
                <form method="post" action="{{ route('admin.reward_conversions.destroy',$c) }}" onsubmit="return confirmDelete(this)">
                  @csrf @method('DELETE')
                  <button type="submit" class="btn btn-sm btn-outline-danger btn-soft">
                    <i class="fa-solid fa-trash-can me-1"></i> Delete
                  </button>
                </form>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="8" class="text-center text-muted py-5">
                <i class="fa-regular fa-folder-open fa-2x mb-2 d-block"></i>
                No conversions found.
              </td>
            </tr>
          @endforelse
          </tbody>
        </table>
      </div>

      <div class="mt-3">
        {{ $conversions->links() }}
      </div>
    </div>
  </div>
</div>

@push('scripts')
<script>
(function(){
  // Mobile filters toggle
  const toggle = document.getElementById('filterToggle');
  const filters = document.getElementById('filters');
  if (toggle && filters) {
    toggle.addEventListener('click', function(){
      const open = filters.classList.toggle('open');
      toggle.setAttribute('aria-expanded', open ? 'true' : 'false');
    });
  }

  // Confirm before delete
  window.confirmDelete = function(frm){
    if (!confirm('Delete this conversion?')) return false;
    const btn = frm.querySelector('button[type=submit]');
    if (btn && !btn.dataset.loading) {
      btn.dataset.loading = '1';
      btn.disabled = true;
      btn.insertAdjacentHTML('beforeend',' <i class="fa-solid fa-spinner fa-spin ms-1"></i>');
    }
    return true;
  }
})();
</script>
@endpush
@endsection
