@extends('backend.master')
@section('title','Rate Settings')

@section('content')
<div class="max-w-5xl mx-auto p-4 space-y-5">
  @if(session('success'))<div class="bg-emerald-50 text-emerald-700 p-2 rounded">{{ session('success') }}</div>@endif

  <form method="POST" action="{{ route('admin.rates.store') }}" class="bg-white rounded shadow p-4 space-y-3">
    @csrf
    <div class="grid md:grid-cols-4 gap-3">
      <input class="border rounded p-2" name="name" placeholder="Country name" required>
      <input class="border rounded p-2" name="currency_name" placeholder="Currency" required>
      <input class="border rounded p-2" name="unit_label" placeholder="Unit label (e.g., 1 Rial)">
      <input class="border rounded p-2" name="rate_bdt" placeholder="Rate in BDT" type="number" step="0.01" required>
      <input class="border rounded p-2 md:col-span-2" name="flag_path" placeholder="Flag path (storage/flags/qatar.svg)">
      <input class="border rounded p-2" name="header_bg" placeholder="#58111A">
      <input class="border rounded p-2" name="position" type="number" min="0" placeholder="Position">
      <input class="border rounded p-2 md:col-span-2" name="share_title_bn" placeholder="Share title (BN)">
      <input class="border rounded p-2 md:col-span-2" name="share_title_en" placeholder="Share title (EN)">
      <textarea class="border rounded p-2 md:col-span-2" name="share_desc_bn" placeholder="Share description (BN)"></textarea>
      <textarea class="border rounded p-2 md:col-span-2" name="share_desc_en" placeholder="Share description (EN)"></textarea>
      <select name="is_active" class="border rounded p-2"><option value="1">Active</option><option value="0">Inactive</option></select>
    </div>
    <button class="px-4 py-2 rounded bg-emerald-600 text-white">Create / Update</button>
  </form>

  <div class="bg-white rounded shadow overflow-x-auto">
    <table class="min-w-full text-sm">
      <thead class="bg-gray-50">
      <tr><th class="p-2 text-left">Country</th><th class="p-2">Currency</th><th class="p-2">Rate</th><th class="p-2">Pos</th><th class="p-2">Active</th><th class="p-2">Actions</th></tr>
      </thead>
      <tbody>
      @foreach($countries as $c)
        <tr class="border-t">
          <td class="p-2">{{ $c->name }}</td>
          <td class="p-2 text-center">{{ $c->currency_name }}</td>
          <td class="p-2 text-center">{{ number_format($c->rate_bdt,2) }}</td>
          <td class="p-2 text-center">{{ $c->position }}</td>
          <td class="p-2 text-center">{{ $c->is_active?'Yes':'No' }}</td>
          <td class="p-2">
            <form method="POST" action="{{ route('admin.rates.update',$c) }}" class="inline">@csrf
              <input type="hidden" name="is_active" value="{{ $c->is_active }}">
              <input type="hidden" name="currency_name" value="{{ $c->currency_name }}">
              <input type="hidden" name="unit_label" value="{{ $c->unit_label }}">
              <input type="hidden" name="rate_bdt" value="{{ $c->rate_bdt }}">
              <button class="px-3 py-1 rounded bg-sky-600 text-white">Quick Save</button>
            </form>
            <form method="POST" action="{{ route('admin.rates.toggle',$c) }}" class="inline">@csrf
              <button class="px-3 py-1 rounded bg-gray-700 text-white">{{ $c->is_active?'Hide':'Show' }}</button>
            </form>
          </td>
        </tr>
      @endforeach
      </tbody>
    </table>
  </div>
</div>
@endsection
