<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Purchase #{{ $purchase->id }}</title>
 <script src="https://cdn.tailwindcss.com"></script>
     <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH"
        crossorigin="anonymous"
    >
</head>
<body class="p-6">
  <div class="max-w-3xl mx-auto space-y-4">
    <div class="flex items-center justify-between">
      <h1 class="text-2xl font-bold">Purchase #{{ $purchase->id }}</h1>
      <a href="{{ route('admin.purchases.index') }}" class="px-3 py-2 bg-gray-200 rounded">← Back</a>
    </div>

    <div class="bg-white rounded shadow p-4">
      <dl class="grid grid-cols-2 gap-4">
        <div><dt class="font-semibold">TXN</dt><dd class="font-mono">{{ $purchase->txn_id ?: '—' }}</dd></div>
        <div><dt class="font-semibold">Status</dt><dd>{{ ucfirst($purchase->status) }}</dd></div>
        <div><dt class="font-semibold">User</dt><dd>{{ $purchase->user?->name }} (#{{ $purchase->user_id }})</dd></div>
        <div><dt class="font-semibold">MSISDN</dt><dd>{{ $purchase->msisdn }}</dd></div>
        <div><dt class="font-semibold">Offer</dt><dd>{{ $purchase->offer?->title }} (#{{ $purchase->offer_id }})</dd></div>
        <div><dt class="font-semibold">Price</dt><dd>৳{{ number_format($purchase->price,2) }}</dd></div>
        <div><dt class="font-semibold">Created</dt><dd>{{ $purchase->created_at->format('Y-m-d H:i:s') }}</dd></div>
        <div><dt class="font-semibold">Reference</dt><dd>{{ $purchase->reference ?: '—' }}</dd></div>
      </dl>
    </div>
  </div>
</body>
</html>
