@extends('backend.master')

@section('content')
<div class="mb-3">
    <a href="{{ route('operators.index') }}" class="btn btn-secondary">&larr; Back</a>
    <a href="{{ route('operators.edit', $operator) }}" class="btn btn-warning">Edit</a>
</div>

<div class="card p-3">
    <div class="d-flex align-items-center gap-3 mb-3">
        @if($operator->logo)
            <img src="{{ asset('storage/'.$operator->logo) }}" alt="Logo" style="height:64px;">
        @endif
        <div>
            <h2 class="h4 mb-0">{{ $operator->name }}</h2>
            <div class="text-muted">Code: <code>{{ $operator->code }}</code></div>
        </div>
    </div>

    <dl class="row mb-0">
        <dt class="col-sm-3">Status</dt>
        <dd class="col-sm-9">{{ ucfirst($operator->status) }}</dd>

        <dt class="col-sm-3">Sort Order</dt>
        <dd class="col-sm-9">{{ $operator->sort_order }}</dd>

        <dt class="col-sm-3">Created</dt>
        <dd class="col-sm-9">{{ $operator->created_at->format('Y-m-d H:i') }}</dd>

        <dt class="col-sm-3">Updated</dt>
        <dd class="col-sm-9">{{ $operator->updated_at->format('Y-m-d H:i') }}</dd>
    </dl>
</div>
@endsection
