@extends('backend.master')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h3">Operators</h1>
    <a href="{{ route('operators.create') }}" class="btn btn-primary">+ New</a>
</div>

@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

<table class="table table-bordered align-middle">
    <thead>
        <tr>
            <th>Sort</th>
            <th>Logo</th>
            <th>Name</th>
            <th>Code</th>
            <th>Status</th>
            <th style="width:180px;">Actions</th>
        </tr>
    </thead>
    <tbody>
        @forelse ($operators as $op)
            <tr>
                <td>{{ $op->sort_order }}</td>
                <td>
                    @if($op->logo)
                        <img src="{{ asset('storage/'.$op->logo) }}" alt="Logo" style="height:38px;">
                    @endif
                </td>
                <td><a href="{{ route('operators.show', $op) }}">{{ $op->name }}</a></td>
                <td><code>{{ $op->code }}</code></td>
                <td>
                    <span class="badge {{ $op->status === 'active' ? 'bg-success' : 'bg-secondary' }}">
                        {{ ucfirst($op->status) }}
                    </span>
                </td>
                <td>
                    <a href="{{ route('operators.edit', $op) }}" class="btn btn-sm btn-warning">Edit</a>
                    <form action="{{ route('operators.destroy', $op) }}" method="POST" class="d-inline"
                          onsubmit="return confirm('Delete this operator?');">
                        @csrf @method('DELETE')
                        <button class="btn btn-sm btn-danger">Delete</button>
                    </form>
                </td>
            </tr>
        @empty
            <tr><td colspan="6" class="text-center text-muted">No operators found.</td></tr>
        @endforelse
    </tbody>
</table>

{{ $operators->links() }}
@endsection
