<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Offer #{{ $offer->id }}</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
      <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
     <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH"
        crossorigin="anonymous"
    >
</head>
<body class="p-6">
  <div class="max-w-3xl mx-auto space-y-4">
    <div class="flex items-center justify-between">
      <h1 class="text-2xl font-bold">{{ $offer->title }}</h1>
      <a href="{{ route('admin.offers.edit',$offer) }}" class="px-3 py-2 bg-yellow-500 text-white rounded">Edit</a>
    </div>

    <div class="bg-white rounded shadow p-4">
      <dl class="grid grid-cols-2 gap-4">
        <div><dt class="font-semibold">Operator</dt><dd>{{ $offer->operator?->name }}</dd></div>
        <div><dt class="font-semibold">Status</dt><dd>{{ ucfirst($offer->status) }}</dd></div>
        <div><dt class="font-semibold">Regular Price</dt><dd>{{ number_format($offer->regular_price,2) }}</dd></div>
        <div><dt class="font-semibold">Sale Price</dt><dd>{{ number_format($offer->sale_price,2) }}</dd></div>
        <div><dt class="font-semibold">Data (GB)</dt><dd>{{ $offer->data_gb ?? '-' }}</dd></div>
        <div><dt class="font-semibold">Minutes</dt><dd>{{ $offer->minutes ?? '-' }}</dd></div>
        <div><dt class="font-semibold">Validity</dt><dd>{{ $offer->validity_days ? $offer->validity_days.' days' : '-' }}</dd></div>
        <div><dt class="font-semibold">Sort Order</dt><dd>{{ $offer->sort_order }}</dd></div>
      </dl>
    </div>

    <div>
      <a href="{{ route('admin.offers.index') }}" class="px-3 py-2 bg-gray-200 rounded">← Back</a>
    </div>
  </div>
</body>
</html>
