<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Offers</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
     <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
     <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH"
        crossorigin="anonymous"
    >
</head>
<body class="p-6">
  <div class="max-w-6xl mx-auto">
    <div class="flex items-center justify-between mb-6">
      <h1 class="text-2xl font-bold">Offers</h1>
      <a href="{{ route('admin.offers.create') }}" class="px-4 py-2 bg-blue-600 text-white rounded">+ Create</a>
    </div>

    @if(session('success'))
      <div class="mb-4 p-3 bg-green-100 text-green-800 rounded">{{ session('success') }}</div>
    @endif

    <form method="get" class="mb-4">
      <input type="text" name="q" value="{{ $q }}" placeholder="Search title/operator"
             class="border rounded px-3 py-2 w-64">
      <button class="px-3 py-2 bg-gray-800 text-white rounded">Search</button>
    </form>

    <div class="overflow-x-auto bg-white shadow rounded">
      <table class="min-w-full text-sm">
        <thead>
          <tr class="bg-gray-100 text-left">
            <th class="px-3 py-2">#</th>
            <th class="px-3 py-2">Title</th>
            <th class="px-3 py-2">Operator</th>
            <th class="px-3 py-2">Price</th>
            <th class="px-3 py-2">Data (GB)</th>
            <th class="px-3 py-2">Minutes</th>
            <th class="px-3 py-2">Validity</th>
            <th class="px-3 py-2">Status</th>
            <th class="px-3 py-2">Sort</th>
            <th class="px-3 py-2 text-right">Actions</th>
          </tr>
        </thead>
        <tbody>
          @forelse($offers as $offer)
            <tr class="border-t">
              <td class="px-3 py-2">{{ $offer->id }}</td>
              <td class="px-3 py-2">
                <a href="{{ route('admin.offers.show',$offer) }}" class="text-blue-700 hover:underline">
                  {{ $offer->title }}
                </a>
              </td>
              <td class="px-3 py-2">{{ $offer->operator?->name }}</td>
              <td class="px-3 py-2">
                @if($offer->sale_price > 0)
                  <span class="line-through text-gray-500">{{ number_format($offer->regular_price,2) }}</span>
                  <span class="font-semibold">{{ number_format($offer->sale_price,2) }}</span>
                @else
                  <span>{{ number_format($offer->regular_price,2) }}</span>
                @endif
              </td>
              <td class="px-3 py-2">{{ $offer->data_gb ?? '-' }}</td>
              <td class="px-3 py-2">{{ $offer->minutes ?? '-' }}</td>
              <td class="px-3 py-2">{{ $offer->validity_days ? $offer->validity_days.' d' : '-' }}</td>
              <td class="px-3 py-2">
                <span class="px-2 py-1 rounded text-white {{ $offer->status==='active'?'bg-green-600':'bg-gray-500' }}">
                  {{ ucfirst($offer->status) }}
                </span>
              </td>
              <td class="px-3 py-2">{{ $offer->sort_order }}</td>
              <td class="px-3 py-2 text-right">
                <a href="{{ route('admin.offers.edit',$offer) }}" class="px-2 py-1 bg-yellow-500 text-white rounded">Edit</a>
                <form action="{{ route('admin.offers.destroy',$offer) }}" method="post" class="inline"
                      onsubmit="return confirm('Delete this offer?');">
                  @csrf @method('DELETE')
                  <button class="px-2 py-1 bg-red-600 text-white rounded">Delete</button>
                </form>
              </td>
            </tr>
          @empty
            <tr><td colspan="10" class="px-3 py-6 text-center text-gray-500">No offers found</td></tr>
          @endforelse
        </tbody>
      </table>
    </div>

    <div class="mt-4">{{ $offers->links() }}</div>
  </div>
</body>
</html>
