<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Create Offer</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
     <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
        rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH"
        crossorigin="anonymous"
    >
</head>
<body class="p-6">
  <div class="max-w-3xl mx-auto">
    <h1 class="text-2xl font-bold mb-4">Create Offer</h1>

    @if ($errors->any())
      <div class="mb-4 p-3 bg-red-100 text-red-800 rounded">
        <ul class="list-disc pl-5">
          @foreach ($errors->all() as $error) <li>{{ $error }}</li> @endforeach
        </ul>
      </div>
    @endif

    <form method="post" action="{{ route('admin.offers.store') }}" class="space-y-4 bg-white p-4 rounded shadow">
      @csrf

      <div>
        <label class="block mb-1">Operator <span class="text-red-600">*</span></label>
        <select name="operator_id" class="border rounded px-3 py-2 w-full" required>
          <option value="">-- Select Operator --</option>
          @foreach($operators as $id => $name)
            <option value="{{ $id }}" @selected(old('operator_id')==$id)>{{ $name }}</option>
          @endforeach
        </select>
      </div>

      <div>
        <label class="block mb-1">Title *</label>
        <input type="text" name="title" value="{{ old('title') }}" class="border rounded px-3 py-2 w-full" required>
      </div>

      <div class="grid grid-cols-2 gap-4">
        <div>
          <label class="block mb-1">Regular Price *</label>
          <input type="number" step="0.01" min="0" name="regular_price" value="{{ old('regular_price',0) }}" class="border rounded px-3 py-2 w-full" required>
        </div>
        <div>
          <label class="block mb-1">Sale Price</label>
          <input type="number" step="0.01" min="0" name="sale_price" value="{{ old('sale_price',0) }}" class="border rounded px-3 py-2 w-full">
        </div>
      </div>

      <div class="grid grid-cols-3 gap-4">
        <div>
          <label class="block mb-1">Data (GB)</label>
          <input type="number" min="0" name="data_gb" value="{{ old('data_gb') }}" class="border rounded px-3 py-2 w-full">
        </div>
        <div>
          <label class="block mb-1">Minutes</label>
          <input type="number" min="0" name="minutes" value="{{ old('minutes') }}" class="border rounded px-3 py-2 w-full">
        </div>
        <div>
          <label class="block mb-1">Validity (days)</label>
          <input type="number" min="0" name="validity_days" value="{{ old('validity_days') }}" class="border rounded px-3 py-2 w-full">
        </div>
      </div>

      <div class="grid grid-cols-2 gap-4">
        <div>
          <label class="block mb-1">Status *</label>
          <select name="status" class="border rounded px-3 py-2 w-full">
            <option value="active" @selected(old('status','active')==='active')>Active</option>
            <option value="inactive" @selected(old('status')==='inactive')>Inactive</option>
          </select>
        </div>
        <div>
          <label class="block mb-1">Sort Order</label>
          <input type="number" min="0" name="sort_order" value="{{ old('sort_order',0) }}" class="border rounded px-3 py-2 w-full">
        </div>
      </div>

      <div class="flex gap-3">
        <button class="px-4 py-2 bg-blue-600 text-white rounded">Save</button>
        <a href="{{ route('admin.offers.index') }}" class="px-4 py-2 bg-gray-200 rounded">Cancel</a>
      </div>
    </form>
  </div>
</body>
</html>
