@extends('backend.master')

@section('title', 'Notifications')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-6">
            <h4>Notifications</h4>
        </div>
        <div class="col-md-6 text-end">
            <span class="badge bg-primary">Unread: {{ $unreadCount }}</span>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            @if($notifications->count())
                <div class="table-responsive">
                    <table class="table table-striped mb-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Title</th>
                                <th>Message</th>
                                <th>Amount</th>
                                <th>Type</th>
                                <th>Status</th>
                                <th>Created At</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($notifications as $notification)
                                <tr class="{{ $notification->read_at ? '' : 'table-warning' }}">
                                    <td>{{ $notification->id }}</td>
                                    <td>{{ $notification->title ?? 'Notification' }}</td>
                                    <td>{{ $notification->message ?? 'N/A' }}</td>
                                    <td>
                                        @if(!is_null($notification->amount))
                                            {{ number_format($notification->amount, 2) }} TK
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td>{{ $notification->type ?? '-' }}</td>
                                    <td>
                                        @if(is_null($notification->read_at))
                                            <span class="badge bg-warning text-dark">Unread</span>
                                        @else
                                            <span class="badge bg-success">Read</span>
                                        @endif
                                    </td>
                                    <td>{{ $notification->created_at->format('d M Y, h:i A') }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="p-3">
                    {{ $notifications->links() }}
                </div>
            @else
                <div class="p-4 text-center text-muted">
                    No notifications found.
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
