<!doctype html>
<html lang="bn">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Loan #{{ $loan->id }}</title><script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-50 p-6">
  <div class="mx-auto max-w-3xl space-y-4">
    @if(session('success'))
      <div class="rounded border border-emerald-200 bg-emerald-50 p-3 text-emerald-800">{{ session('success') }}</div>
    @endif

    <div class="rounded border bg-white p-4">
      <div class="text-lg font-bold mb-2">Loan #{{ $loan->id }}</div>
      <div class="grid grid-cols-2 gap-3 text-sm">
        <div>Applicant: <b>{{ $loan->user?->name ?? 'N/A' }}</b></div>
        <div>Status: <b>{{ ucfirst($loan->status) }}</b></div>
        <div>Amount: <b>৳{{ number_format($loan->loan_amount) }}</b></div>
        <div>Period: <b>{{ $loan->loan_period }} months</b></div>
        <div>Interest: <b>{{ number_format($loan->interest_rate,2) }}%</b></div>
        <div>Total: <b>৳{{ number_format($loan->estimated_total,2) }}</b></div>
      </div>

      @if($loan->image_path)
        <div class="mt-3">
          <div class="text-sm text-slate-500">Document:</div>
          <img src="{{ $loan->image_path }}" class="mt-1 max-h-60 rounded border">
        </div>
      @endif

      @if($loan->status === 'pending')
        <div class="mt-4 flex gap-2">
          <form method="post" action="{{ route('admin.loans.approve',$loan) }}">@csrf
            <button class="rounded bg-emerald-600 px-4 py-2 text-white">Approve & Credit</button>
          </form>
          <form method="post" action="{{ route('admin.loans.reject',$loan) }}">@csrf
            <button class="rounded bg-rose-600 px-4 py-2 text-white">Reject</button>
          </form>
        </div>
      @endif
    </div>

    @if($loan->repayments->count())
      <div class="rounded border bg-white p-4">
        <div class="font-semibold mb-2">Repayment Schedule</div>
        <div class="space-y-2">
          @foreach($loan->repayments as $r)
            <div class="flex items-center justify-between rounded border px-3 py-2 text-sm">
              <div>{{ $r->due_date->format('d M Y') }}</div>
              <div>৳{{ number_format($r->amount,2) }}</div>
              <div class="flex items-center gap-2">
                <span class="text-xs {{ $r->status==='paid' ? 'text-emerald-700' : 'text-amber-700' }}">{{ ucfirst($r->status) }}</span>
                @if($r->status === 'due')
                  <form method="post" action="{{ route('admin.loans.repayments.paid',[$loan,$r]) }}">@csrf
                    <button class="rounded bg-emerald-600 px-2 py-1 text-white text-xs">Mark Paid</button>
                  </form>
                @endif
              </div>
            </div>
          @endforeach
        </div>
      </div>
    @endif
  </div>
</body>
</html>
