@extends('backend.master')

@push('styles')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
<style>
:root{ --gap:12px; --border:#e9ecef; --muted:#6c757d; }
.card{ border-radius:12px; } .card-header{ border-bottom:1px solid var(--border); }
.table thead th{ font-weight:600; text-transform:uppercase; font-size:12px; letter-spacing:.04em; border-bottom:2px solid var(--border)!important;}
.table td{ vertical-align:middle; }
.badge{ padding:.5em .65em; font-weight:600; }
.btn-soft{ border:1px solid rgba(0,0,0,.08); background:#fff; box-shadow:0 1px 2px rgba(0,0,0,.04); }
.btn-soft:hover{ box-shadow:0 2px 6px rgba(0,0,0,.08); }

/* Modal */
.cmodal{ position:fixed; inset:0; z-index:1090; display:none; align-items:center; justify-content:center;}
.cmodal.show{ display:flex; }
.cmodal .cm-backdrop{ position:absolute; inset:0; background:rgba(10,12,16,.55); backdrop-filter:blur(2px);}
.cmodal .cm-dialog{ position:relative; z-index:1; width:min(520px, calc(100% - 32px)); border-radius:14px; background:#fff; box-shadow:0 20px 60px rgba(0,0,0,.25); overflow:hidden; transform:translateY(16px) scale(.98); opacity:0; transition:transform .18s ease, opacity .18s ease;}
.cmodal.show .cm-dialog{ transform:translateY(0) scale(1); opacity:1;}
.cm-header{ padding:14px 18px; border-bottom:1px solid #edf1f5; display:flex; align-items:center; gap:10px;}
.cm-title{ font-size:18px; font-weight:700; margin:0; display:flex; align-items:center; gap:10px;}
.cm-body{ padding:18px;} .cm-footer{ padding:14px 18px; border-top:1px solid #edf1f5; display:flex; justify-content:flex-end; gap:10px;}
.cm-close{ margin-left:auto; appearance:none; border:0; background:transparent; font-size:22px; line-height:1; padding:0 6px; cursor:pointer; color:var(--muted);}
.cm-close:hover{ color:#111; transform:scale(1.05); }
.cm-btn{ border:0; border-radius:10px; padding:9px 14px; cursor:pointer; font-weight:600;}
.cm-btn.light{ background:#f1f3f5; color:#111;}
.cm-btn.success{ background:#198754; color:#fff;}
</style>
@endpush

@section('content')
<div class="container py-4">
  <div class="card shadow-sm border-0">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
      <h5 class="mb-0"><i class="fa-solid fa-list-check me-2"></i> Repayment Schedule — Loan #{{ $loan->id }} ({{ $loan->user?->name ?? 'Guest' }})</h5>
      <a href="{{ route('admin.loans.index') }}" class="btn btn-sm btn-soft"><i class="fa-solid fa-arrow-left me-1"></i> Back</a>
    </div>

    <div class="card-body">
      @if(session('ok'))
        <div class="alert alert-success mb-3"><i class="fa-solid fa-circle-check me-1"></i>{{ session('ok') }}</div>
      @endif

      <div class="table-responsive">
        <table class="table align-middle">
          <thead>
            <tr>
              <th>#</th>
              <th>Due Date</th>
              <th>Amount</th>
              <th>Status</th>
              <th>Paid At</th>
              <th class="text-end">Actions</th>
            </tr>
          </thead>
          <tbody>
          @forelse($repayments as $rp)
            <tr>
              <td class="text-muted">#{{ $rp->id }}</td>
              <td><i class="fa-regular fa-calendar me-1 text-muted"></i>{{ $rp->due_date?->format('Y-m-d') }}</td>
              <td><i class="fa-solid fa-bangladeshi-taka-sign me-1 text-muted"></i>{{ number_format($rp->amount,2) }}</td>
              <td>
                @php
                  $badgeClass = $rp->status==='paid' ? 'bg-success' : 'bg-warning text-dark';
                  $icon = $rp->status==='paid' ? 'fa-circle-check' : 'fa-hourglass-half';
                @endphp
                <span class="badge {{ $badgeClass }}"><i class="fa-solid {{ $icon }} me-1"></i>{{ ucfirst($rp->status) }}</span>
              </td>
              <td>{{ $rp->paid_at ? $rp->paid_at->format('Y-m-d H:i') : '—' }}</td>
              <td class="text-end">
                @if($rp->status==='due')
                  <button type="button" class="btn btn-sm btn-success" onclick="openPaidModal('{{ route('admin.loans.repayments.mark_paid',$rp) }}')">
                    <i class="fa-solid fa-check me-1"></i> Mark Paid
                  </button>
                @else
                  <span class="text-muted">—</span>
                @endif
              </td>
            </tr>
          @empty
            <tr><td colspan="6" class="text-center text-muted py-5"><i class="fa-regular fa-folder-open fa-2x mb-2 d-block"></i>No repayments found.</td></tr>
          @endforelse
          </tbody>
        </table>
      </div>

      <div class="mt-3">{{ $repayments->links() }}</div>
    </div>
  </div>
</div>

{{-- Mark Paid Modal --}}
<div id="paidModal" class="cmodal" aria-hidden="true">
  <div class="cm-backdrop" data-close="1"></div>
  <div class="cm-dialog" role="dialog" aria-modal="true" aria-labelledby="pmTitle">
    <form id="paidForm" method="post" onsubmit="return lockSubmit(this)">
      @csrf
      <div class="cm-header">
        <h5 class="cm-title" id="pmTitle"><i class="fa-solid fa-circle-check" style="color:#198754"></i> Confirm payment</h5>
        <button type="button" class="cm-close" aria-label="Close" data-close="1">&times;</button>
      </div>
      <div class="cm-body">
        <p class="mb-0"><i class="fa-solid fa-circle-info me-1"></i> This will set status to <strong>paid</strong> and record <em>paid_at = now</em>.</p>
      </div>
      <div class="cm-footer">
        <button type="button" class="cm-btn light" data-close="1"><i class="fa-regular fa-circle-xmark me-1"></i> Cancel</button>
        <button id="pmSubmit" type="submit" class="cm-btn success"><i class="fa-solid fa-check me-1"></i> Mark Paid</button>
      </div>
    </form>
  </div>
</div>

@push('scripts')
<script>
(function(){
  const modal  = document.getElementById('paidModal');
  const dialog = modal.querySelector('.cm-dialog');
  const form   = modal.querySelector('#paidForm');

  window.openPaidModal = function(actionUrl){
    form.action = actionUrl;
    show();
  };
  function show(){ modal.classList.add('show'); modal.removeAttribute('aria-hidden'); document.addEventListener('keydown', escClose); document.documentElement.style.overflow = 'hidden'; }
  function hide(){ modal.classList.remove('show'); modal.setAttribute('aria-hidden','true'); document.removeEventListener('keydown', escClose); document.documentElement.style.overflow = ''; }
  function escClose(e){ if (e.key==='Escape') hide(); }
  modal.addEventListener('click', e => { if (e.target.dataset.close) hide(); });
  dialog.addEventListener('click', e => e.stopPropagation());
  modal.querySelectorAll('[data-close]').forEach(btn => btn.addEventListener('click', hide));

  window.lockSubmit = function(frm){
    const btn = frm.querySelector('button[type=submit]');
    if (btn && !btn.dataset.loading) { btn.dataset.loading='1'; btn.disabled=true; btn.insertAdjacentHTML('beforeend',' <i class="fa-solid fa-spinner fa-spin ms-1"></i>'); }
    return true;
  };
})();
</script>
@endpush
@endsection
