@extends('backend.master')

@section('title', 'Headlines')

@section('content')
<div class="container py-4">
    @if (session('status'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('status') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row g-4">
        {{-- Form column --}}
        <div class="col-lg-5">
            <div class="card shadow-sm">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h5 class="mb-0">{{ $editing ? 'Edit Headline' : 'Create Headline' }}</h5>
                    @if($editing)
                        <a href="{{ route('headlines.index') }}" class="btn btn-sm btn-outline-secondary">+ New</a>
                    @endif
                </div>

                <div class="card-body">
                    @if ($editing && $current)
                        <form action="{{ route('headlines.update', $current->id) }}" method="POST" class="row g-3">
                            @csrf
                            @method('PUT')
                            <div class="col-12">
                                <label class="form-label">Headline</label>
                                <textarea name="headline" rows="4"
                                    class="form-control @error('headline') is-invalid @enderror"
                                >{{ old('headline', $current->headline) }}</textarea>
                                @error('headline') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-12 d-flex gap-2">
                                <button class="btn btn-primary">Update</button>
                                <a href="{{ route('headlines.index') }}" class="btn btn-light">Cancel</a>
                            </div>
                        </form>
                    @else
                        <form action="{{ route('headlines.store') }}" method="POST" class="row g-3">
                            @csrf
                            <div class="col-12">
                                <label class="form-label">Headline</label>
                                <textarea name="headline" rows="4"
                                    class="form-control @error('headline') is-invalid @enderror"
                                    placeholder="Write a headline..."
                                >{{ old('headline') }}</textarea>
                                @error('headline') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-12">
                                <button class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>

        {{-- Table column --}}
        <div class="col-lg-7">
            <div class="card shadow-sm">
                <div class="card-header">
                    <h5 class="mb-0">All Headlines</h5>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th style="width:72px">#</th>
                                <th>Headline</th>
                                <th style="width:160px">Created</th>
                                <th style="width:160px">Updated</th>
                                <th class="text-end" style="width:160px">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                        @forelse ($headlines as $h)
                            <tr>
                                <td>{{ $h->id }}</td>
                                <td>
                                    <div class="text-truncate" style="max-width: 520px;" title="{{ $h->headline }}">
                                        {{ \Illuminate\Support\Str::limit($h->headline, 140) }}
                                    </div>
                                </td>
                                <td><span class="text-muted">{{ optional($h->created_at)->format('d M Y, h:i A') }}</span></td>
                                <td><span class="text-muted">{{ optional($h->updated_at)->format('d M Y, h:i A') }}</span></td>
                                <td class="text-end">
                                    <div class="btn-group">
                                        <a href="{{ route('headlines.edit', $h->id) }}" class="btn btn-sm btn-outline-primary">Edit</a>

                                        {{-- inline delete (no modal) --}}
                                        <form action="{{ route('headlines.destroy', $h->id) }}" method="POST" class="d-inline"
                                              onsubmit="return confirm('Delete this headline?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center text-muted py-5">No headlines found.</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>

                @if($headlines->hasPages())
                <div class="card-footer">
                    {{ $headlines->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
