@extends('backend.master')
@section('title','Gateways')

@section('content')
<div class="max-w-5xl mx-auto p-4 space-y-6">
    <h1 class="text-2xl font-bold">মোবাইল ব্যাংকিং সেটিংস</h1>

    @if(session('success')) <div class="bg-emerald-50 text-emerald-700 px-3 py-2 rounded">{{ session('success') }}</div> @endif

    <div class="grid md:grid-cols-3 gap-4">
        @foreach($gateways as $g)
        <form method="POST" action="{{ route('admin.gateways.update',$g) }}" class="bg-white rounded-2xl shadow p-4 space-y-3">
            @csrf
            <div class="flex items-center gap-3">
                <img src="{{ $g->logo_url }}" class="h-10 w-10" alt="">
                <div>
                    <div class="font-semibold">{{ $g->name }}</div>
                    <div class="text-xs text-gray-500">{{ $g->code }}</div>
                </div>
            </div>
            <div class="grid grid-cols-2 gap-3">
                <x-admin.input label="Min Limit" name="min_limit" :value="$g->min_limit"/>
                <x-admin.input label="Max Limit" name="max_limit" :value="$g->max_limit"/>
                <x-admin.input label="Flat Fee" name="flat_fee" :value="$g->flat_fee"/>
                <x-admin.input label="% Fee" name="percent_fee" :value="$g->percent_fee"/>
                <x-admin.input label="Min Comm" name="min_commission" :value="$g->min_commission"/>
                <x-admin.input label="Max Comm" name="max_commission" :value="$g->max_commission"/>
            </div>
            <div class="flex items-center justify-between">
                <label class="inline-flex items-center gap-2">
                    <input type="hidden" name="name" value="{{ $g->name }}">
                    <input type="hidden" name="code" value="{{ $g->code }}">
                    <input type="checkbox" name="is_active" value="1" @checked($g->is_active) class="rounded">
                    <span class="text-sm">Active</span>
                </label>
                <button class="px-4 py-2 rounded-xl bg-emerald-600 text-white">Save</button>
            </div>
        </form>
        @endforeach
    </div>
</div>
@endsection
