@extends('backend.master')

@section('content')
<div class="container">
    <h3>Deposit #{{ $deposit->id }}</h3>
    <div class="row">
        <div class="col-md-7">
            <div class="card mb-3">
                <div class="card-header">Details</div>
                <div class="card-body">
                    <dl class="row">
                        <dt class="col-sm-4">User</dt><dd class="col-sm-8">#{{ $deposit->user_id }}</dd>
                        <dt class="col-sm-4">Method</dt><dd class="col-sm-8">{{ $deposit->method->name }}</dd>
                        <dt class="col-sm-4">Amount</dt><dd class="col-sm-8">{{ number_format($deposit->amount,2) }}</dd>
                        <dt class="col-sm-4">Payer phone</dt><dd class="col-sm-8">{{ $deposit->payer_phone }}</dd>
                        <dt class="col-sm-4">Reference</dt><dd class="col-sm-8"><code>{{ $deposit->reference }}</code></dd>
                        <dt class="col-sm-4">Status</dt><dd class="col-sm-8">{{ ucfirst($deposit->status) }}</dd>
                        <dt class="col-sm-4">Created</dt><dd class="col-sm-8">{{ $deposit->created_at->toDayDateTimeString() }}</dd>
                    </dl>
                    @if($deposit->proof_path)
                        <a href="{{ Storage::disk('public')->url($deposit->proof_path) }}" target="_blank" class="btn btn-sm btn-outline-secondary">View Proof</a>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-md-5">
            @if ($deposit->status === 'pending')
            <form class="card mb-3" method="post" action="{{ route('admin.deposits.approve',$deposit) }}">
                @csrf @method('PUT')
                <div class="card-header">Approve</div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Admin note (optional)</label>
                        <textarea name="note" class="form-control"></textarea>
                    </div>
                    <button class="btn btn-success w-100">Approve &amp; Credit Wallet</button>
                </div>
            </form>
            <form class="card" method="post" action="{{ route('admin.deposits.reject',$deposit) }}">
                @csrf @method('PUT')
                <div class="card-header">Reject</div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Reason</label>
                        <textarea required name="note" class="form-control"></textarea>
                    </div>
                    <button class="btn btn-danger w-100">Reject</button>
                </div>
            </form>
            @else
            <div class="alert alert-secondary">This deposit is {{ $deposit->status }}.</div>
            @endif
        </div>
    </div>
</div>
@endsection
