<!doctype html>
<html lang="bn">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Deposit Packages</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="p-6 bg-slate-50">
  <div class="mx-auto max-w-6xl">
    <div class="mb-4 flex items-center justify-between">
      <h1 class="text-2xl font-bold">Deposit Packages</h1>
      <a href="{{ route('admin.packages.create') }}" class="rounded-lg bg-teal-700 px-4 py-2 text-white">+ Create</a>
    </div>

    @if(session('success'))
      <div class="mb-3 rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-emerald-800">{{ session('success') }}</div>
    @endif

    <form method="get" class="mb-3 flex gap-2">
      <input name="q" value="{{ $q }}" placeholder="Search title" class="rounded border px-3 py-2">
      <select name="status" class="rounded border px-3 py-2">
        <option value="">All</option>
        @foreach(['active','inactive'] as $s)
          <option value="{{ $s }}" @selected($status===$s)>{{ ucfirst($s) }}</option>
        @endforeach
      </select>
      <button class="rounded bg-slate-800 px-3 py-2 text-white">Filter</button>
      <a href="{{ route('admin.settings.deposit.edit') }}" class="ml-auto rounded border px-3 py-2">⚙ Settings</a>
    </form>

    <div class="overflow-x-auto rounded-lg border bg-white">
      <table class="min-w-full text-sm">
        <thead class="bg-slate-100 text-left">
          <tr>
            <th class="px-3 py-2">#</th>
            <th class="px-3 py-2">Title</th>
            <th class="px-3 py-2">Principal</th>
            <th class="px-3 py-2">Bonus %</th>
            <th class="px-3 py-2">Badge</th>
            <th class="px-3 py-2">Status</th>
            <th class="px-3 py-2">Sort</th>
            <th class="px-3 py-2 text-right">Actions</th>
          </tr>
        </thead>
        <tbody>
          @forelse($packages as $p)
            <tr class="border-t">
              <td class="px-3 py-2">{{ $p->id }}</td>
              <td class="px-3 py-2">{{ $p->title }}</td>
              <td class="px-3 py-2">{{ number_format($p->principal_amount,2) }}</td>
              <td class="px-3 py-2">{{ number_format($p->bonus_percent,2) }}%</td>
              <td class="px-3 py-2">{{ $p->badge_text }}</td>
              <td class="px-3 py-2">
                <span class="rounded px-2 py-1 text-white {{ $p->status==='active'?'bg-green-600':'bg-slate-500' }}">{{ ucfirst($p->status) }}</span>
              </td>
              <td class="px-3 py-2">{{ $p->sort_order }}</td>
              <td class="px-3 py-2 text-right">
                <a class="rounded bg-amber-500 px-2 py-1 text-white" href="{{ route('admin.packages.edit',$p) }}">Edit</a>
                <form class="inline" method="post" action="{{ route('admin.packages.destroy',$p) }}" onsubmit="return confirm('Delete?');">
                  @csrf @method('DELETE')
                  <button class="rounded bg-rose-600 px-2 py-1 text-white">Delete</button>
                </form>
              </td>
            </tr>
          @empty
            <tr><td colspan="8" class="px-3 py-6 text-center text-slate-500">No packages.</td></tr>
          @endforelse
        </tbody>
      </table>
    </div>

    <div class="mt-4">{{ $packages->links() }}</div>
  </div>
</body>
</html>
