<!doctype html>
<html lang="bn">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Create Package</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="p-6 bg-slate-50">
  <div class="mx-auto max-w-2xl">
    <h1 class="mb-4 text-2xl font-bold">Create Package</h1>

    @if ($errors->any())
      <div class="mb-3 rounded border border-rose-200 bg-rose-50 p-3 text-rose-800">
        <ul class="list-disc pl-5">@foreach($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul>
      </div>
    @endif

    <form method="post" action="{{ route('admin.packages.store') }}" class="space-y-4 rounded-lg border bg-white p-4">
      @csrf

      <label class="block">
        <span class="text-sm font-medium">Title</span>
        <input name="title" value="{{ old('title') }}" class="mt-1 w-full rounded border px-3 py-2" required>
      </label>

      <div class="grid grid-cols-2 gap-3">
        <label class="block">
          <span class="text-sm font-medium">Principal Amount</span>
          <input type="number" step="0.01" min="1" name="principal_amount" value="{{ old('principal_amount') }}" class="mt-1 w-full rounded border px-3 py-2" required>
        </label>
        <label class="block">
          <span class="text-sm font-medium">Bonus %</span>
          <input type="number" step="0.01" min="0" max="100" name="bonus_percent" value="{{ old('bonus_percent',1.2) }}" class="mt-1 w-full rounded border px-3 py-2" required>
        </label>
      </div>

      <div class="grid grid-cols-2 gap-3">
        <label class="block">
          <span class="text-sm font-medium">Badge Text</span>
          <input name="badge_text" value="{{ old('badge_text') }}" placeholder="যেমন: ১.২%" class="mt-1 w-full rounded border px-3 py-2">
        </label>
        <label class="block">
          <span class="text-sm font-medium">Sort Order</span>
          <input type="number" min="0" name="sort_order" value="{{ old('sort_order',0) }}" class="mt-1 w-full rounded border px-3 py-2">
        </label>
      </div>

      <label class="block">
        <span class="text-sm font-medium">Status</span>
        <select name="status" class="mt-1 w-full rounded border px-3 py-2">
          <option value="active" @selected(old('status','active')==='active')>Active</option>
          <option value="inactive" @selected(old('status')==='inactive')>Inactive</option>
        </select>
      </label>

      <div class="flex gap-2">
        <button class="rounded bg-teal-700 px-4 py-2 text-white">Save</button>
        <a href="{{ route('admin.packages.index') }}" class="rounded border px-4 py-2">Cancel</a>
      </div>
    </form>
  </div>
</body>
</html>
