@extends('backend.master')
@section('content')
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="m-0">#{{ $message->id }} • {{ $message->subject }}</h5>
    <div class="d-flex gap-2">
      <form method="POST" action="{{ route('admin.contact.read',$message) }}">@csrf<button class="btn btn-outline-success btn-sm">Mark Read</button></form>
      <form method="POST" action="{{ route('admin.contact.unread',$message) }}">@csrf<button class="btn btn-outline-warning btn-sm">Mark Unread</button></form>
      <form method="POST" action="{{ route('admin.contact.archive',$message) }}">@csrf<button class="btn btn-outline-secondary btn-sm">Archive</button></form>
      <form method="POST" action="{{ route('admin.contact.destroy',$message) }}" onsubmit="return confirm('Delete this message?')">@csrf @method('DELETE')<button class="btn btn-outline-danger btn-sm">Delete</button></form>
    </div>
  </div>

  <div class="card border-0 shadow-sm">
    <div class="card-body">
      <div class="mb-3"><strong>From:</strong> {{ $message->name }} ({{ $message->email }})</div>
      <div class="mb-3"><strong>WhatsApp:</strong> {{ $message->whatsapp ?: '-' }}</div>
      <div class="mb-3"><strong>Received:</strong> {{ $message->created_at->format('M d, Y h:i A') }}</div>
      @if($message->read_at)
        <div class="mb-3"><strong>Read at:</strong> {{ $message->read_at->format('M d, Y h:i A') }}</div>
      @endif
      <hr>
      <div class="lead" style="white-space:pre-wrap">{{ $message->message }}</div>
    </div>
  </div>
</div>
@endsection