@extends('backend.master')
@section('content')
<div class="container py-4">
  <div class="d-flex flex-wrap gap-2 align-items-center mb-3">
    <h4 class="m-0">Contact Inbox</h4>
    <div class="ms-auto d-flex gap-2">
      <a href="{{ route('admin.contact.index',['status'=>'unread']) }}" class="btn btn-sm btn-outline-danger">Unread ({{ $counts['unread'] }})</a>
      <a href="{{ route('admin.contact.index',['status'=>'read']) }}" class="btn btn-sm btn-outline-success">Read ({{ $counts['read'] }})</a>
      <a href="{{ route('admin.contact.index',['status'=>'archived']) }}" class="btn btn-sm btn-outline-secondary">Archived ({{ $counts['archived'] }})</a>
    </div>
  </div>

  <form method="GET" class="mb-3">
    <div class="input-group">
      <input type="text" class="form-control" placeholder="Search name/email/subject" name="q" value="{{ $q }}">
      <button class="btn btn-outline-secondary">Search</button>
    </div>
  </form>

  <div class="card border-0 shadow-sm">
    <div class="table-responsive">
      <table class="table align-middle mb-0">
        <thead>
          <tr>
            <th>#</th>
            <th>Subject</th>
            <th>From</th>
            <th>WhatsApp</th>
            <th>Status</th>
            <th>Received</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          @forelse($messages as $m)
          <tr class="{{ $m->status==='unread' ? 'table-warning' : '' }}">
            <td>{{ $m->id }}</td>
            <td><a href="{{ route('admin.contact.show',$m) }}" class="fw-semibold text-decoration-none">{{ Str::limit($m->subject, 60) }}</a></td>
            <td>{{ $m->name }}<br><small class="text-muted">{{ $m->email }}</small></td>
            <td>{{ $m->whatsapp }}</td>
            <td><span class="badge bg-{{ $m->status==='unread'?'danger':($m->status==='read'?'success':'secondary') }}">{{ ucfirst($m->status) }}</span></td>
            <td>{{ $m->created_at->diffForHumans() }}</td>
            <td class="text-end">
              <div class="btn-group">
                <form method="POST" action="{{ route('admin.contact.read',$m) }}">@csrf<button class="btn btn-sm btn-outline-success">Read</button></form>
                <form method="POST" action="{{ route('admin.contact.unread',$m) }}" class="ms-1">@csrf<button class="btn btn-sm btn-outline-warning">Unread</button></form>
                <form method="POST" action="{{ route('admin.contact.archive',$m) }}" class="ms-1">@csrf<button class="btn btn-sm btn-outline-secondary">Archive</button></form>
                <form method="POST" action="{{ route('admin.contact.destroy',$m) }}" class="ms-1" onsubmit="return confirm('Delete this message?')">@csrf @method('DELETE')<button class="btn btn-sm btn-outline-danger">Delete</button></form>
              </div>
            </td>
          </tr>
          @empty
            <tr><td colspan="7" class="text-center text-muted p-4">No messages</td></tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>

  <div class="mt-3">{{ $messages->links() }}</div>
</div>
@endsection