@extends('backend.master')

@section('title', 'Company Setups')

@section('content')
<div class="container py-4">
    @if (session('status'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('status') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="d-flex align-items-center justify-content-between mb-3">
        <h1 class="h4 mb-0">Company Setups</h1>
        <a href="{{ route('company-setups.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-lg me-1"></i> Create
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="table-responsive">
            <table class="table align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>About</th>
                        <th>Phone</th>
                        <th>WhatsApp</th>
                        <th>Email</th>
                        <th>Telegram</th>
                        <th>Facebook</th>
                        <th>Address</th>
                        <th>Favicon</th>
                        <th>Logo</th>
                        <th>Created</th>
                        <th>Updated</th>
                        <th class="text-end">Actions</th>
                    </tr>
                </thead>
                <tbody>
                @forelse ($companySetups as $setup)
                    <tr>
                        <td>{{ $setup->id }}</td>
                        <td>{{ $setup->company_name ?? '—' }}</td>

                        {{-- About (truncate) --}}
                        <td style="max-width: 260px;">
                            <span class="d-inline-block text-truncate" style="max-width: 260px;"
                                  title="{{ $setup->about_company }}">
                                {{ \Illuminate\Support\Str::limit($setup->about_company, 80) ?: '—' }}
                            </span>
                        </td>

                        <td>{{ $setup->phone_number ?? '—' }}</td>
                        <td>{{ $setup->whatsapp_number ?? '—' }}</td>
                        <td>{{ $setup->email ?? '—' }}</td>

                        {{-- Telegram --}}
                        <td>
                            @if($setup->telegram_link)
                                <a href="{{ $setup->telegram_link }}" target="_blank" rel="noopener" class="link-primary text-decoration-none">
                                    {{ \Illuminate\Support\Str::limit($setup->telegram_link, 24) }}
                                </a>
                            @else
                                —
                            @endif
                        </td>

                        {{-- Facebook --}}
                        <td>
                            @if($setup->facebook_link)
                                <a href="{{ $setup->facebook_link }}" target="_blank" rel="noopener" class="link-primary text-decoration-none">
                                    {{ \Illuminate\Support\Str::limit($setup->facebook_link, 24) }}
                                </a>
                            @else
                                —
                            @endif
                        </td>

                        {{-- Address (truncate) --}}
                        <td style="max-width: 220px;">
                            <span class="d-inline-block text-truncate" style="max-width: 220px;"
                                  title="{{ $setup->address }}">
                                {{ \Illuminate\Support\Str::limit($setup->address, 50) ?: '—' }}
                            </span>
                        </td>

                        {{-- Favicon --}}
                        <td>
                            @if($setup->fav_icon)
                                <img src="{{ asset('storage/'.$setup->fav_icon) }}" alt="favicon"
                                     class="img-thumbnail" style="height:28px; width:28px; object-fit:cover">
                            @else
                                —
                            @endif
                        </td>

                        {{-- Logo --}}
                        <td>
                            @if($setup->logo)
                                <img src="{{ asset('storage/'.$setup->logo) }}" alt="logo"
                                     class="img-fluid border rounded" style="height:32px; object-fit:contain">
                            @else
                                —
                            @endif
                        </td>

                        <td><span class="text-muted">{{ optional($setup->created_at)->format('d M Y, h:i A') }}</span></td>
                        <td><span class="text-muted">{{ optional($setup->updated_at)->format('d M Y, h:i A') }}</span></td>

                        <td class="text-end">
                            <div class="btn-group">
                                <a href="{{ route('company-setups.edit', $setup) }}" class="btn btn-sm btn-outline-primary">
                                    Edit
                                </a>

                                {{-- OPTION A: confirm সহ --}}
                                <form action="{{ route('company-setups.destroy', $setup->id) }}" method="POST" class="d-inline"
                                      onsubmit="return confirm('Delete {{ $setup->company_name ?? 'this company' }}?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                                </form>

                                {{-- OPTION B: confirm ছাড়াই (উপরে যেটা ব্যবহার করেছেন, এটা মুছে দিন)
                                <form action="{{ route('company-setups.destroy', $setup->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                                </form>
                                --}}
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="14" class="text-center text-muted py-5">No records found.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>

        @if($companySetups->hasPages())
        <div class="card-footer">
            {{ $companySetups->links() }}
        </div>
        @endif
    </div>
</div>
@endsection
