@extends('backend.master')

@section('title', 'Edit Company')

@section('content')
<div class="container py-4">
    @if (session('status'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('status') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="d-flex align-items-center justify-content-between mb-3">
        <h1 class="h4 mb-0">Edit Company</h1>
        <a href="{{ route('company-setups.index') }}" class="btn btn-outline-secondary">← Back</a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <form action="{{ route('company-setups.update', $companySetup) }}" method="POST" enctype="multipart/form-data" class="row g-3">
                @csrf
                @method('PUT')

                <div class="col-12">
                    <label class="form-label">Company Name</label>
                    <input type="text" name="company_name" value="{{ old('company_name', $companySetup->company_name) }}"
                           class="form-control @error('company_name') is-invalid @enderror">
                    @error('company_name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" value="{{ old('email', $companySetup->email) }}"
                           class="form-control @error('email') is-invalid @enderror">
                    @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">Phone</label>
                    <input type="text" name="phone_number" value="{{ old('phone_number', $companySetup->phone_number) }}"
                           class="form-control @error('phone_number') is-invalid @enderror">
                    @error('phone_number') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">WhatsApp</label>
                    <input type="text" name="whatsapp_number" value="{{ old('whatsapp_number', $companySetup->whatsapp_number) }}"
                           class="form-control @error('whatsapp_number') is-invalid @enderror">
                    @error('whatsapp_number') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">Telegram Link</label>
                    <input type="url" name="telegram_link" value="{{ old('telegram_link', $companySetup->telegram_link) }}"
                           class="form-control @error('telegram_link') is-invalid @enderror" placeholder="https://t.me/your_channel">
                    @error('telegram_link') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">Facebook Link</label>
                    <input type="url" name="facebook_link" value="{{ old('facebook_link', $companySetup->facebook_link) }}"
                           class="form-control @error('facebook_link') is-invalid @enderror" placeholder="https://facebook.com/your_page">
                    @error('facebook_link') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-12">
                    <label class="form-label">Address</label>
                    <input type="text" name="address" value="{{ old('address', $companySetup->address) }}"
                           class="form-control @error('address') is-invalid @enderror">
                    @error('address') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-12">
                    <label class="form-label">About Company</label>
                    <textarea name="about_company" rows="5"
                              class="form-control @error('about_company') is-invalid @enderror">{{ old('about_company', $companySetup->about_company) }}</textarea>
                    @error('about_company') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">Favicon (png/jpg/webp/ico, ≤2MB)</label>
                    <input type="file" name="fav_icon" accept="image/*"
                           class="form-control @error('fav_icon') is-invalid @enderror" id="favInput">
                    @error('fav_icon') <div class="invalid-feedback">{{ $message }}</div> @enderror

                    <div class="mt-2 d-flex align-items-center gap-3">
                        @if($companySetup->fav_icon)
                            <img src="{{ asset('storage/'.$companySetup->fav_icon) }}" alt="favicon" class="rounded border" style="height:40px; width:40px; object-fit:cover">
                        @endif
                        <img id="favPreview" class="rounded border d-none" style="height:40px; width:40px; object-fit:cover">
                    </div>
                </div>

                <div class="col-md-6">
                    <label class="form-label">Logo (png/jpg/webp/svg, ≤4MB)</label>
                    <input type="file" name="logo" accept="image/*"
                           class="form-control @error('logo') is-invalid @enderror" id="logoInput">
                    @error('logo') <div class="invalid-feedback">{{ $message }}</div> @enderror

                    <div class="mt-2 d-flex align-items-center gap-3">
                        @if($companySetup->logo)
                            <img src="{{ asset('storage/'.$companySetup->logo) }}" alt="logo" class="rounded border" style="height:56px">
                        @endif
                        <img id="logoPreview" class="rounded border d-none" style="height:56px; object-fit:contain">
                    </div>
                </div>

                <div class="col-12 d-flex gap-2 pt-2">
                    <button class="btn btn-primary">Update</button>
                    <a href="{{ route('company-setups.index') }}" class="btn btn-light">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function preview(input, targetId){
    const file = input.files && input.files[0];
    if(!file) return;
    const reader = new FileReader();
    reader.onload = e => {
        const img = document.getElementById(targetId);
        img.src = e.target.result;
        img.classList.remove('d-none');
    };
    reader.readAsDataURL(file);
}
document.getElementById('favInput')?.addEventListener('change', e => preview(e.target, 'favPreview'));
document.getElementById('logoInput')?.addEventListener('change', e => preview(e.target, 'logoPreview'));
</script>
@endpush
