@extends('backend.master')

@section('title', 'Create Company')

@section('content')
<div class="container py-4">
    <div class="d-flex align-items-center justify-content-between mb-3">
        <h1 class="h4 mb-0">Create Company</h1>
        <a href="{{ route('company-setups.index') }}" class="btn btn-outline-secondary">← Back</a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <form action="{{ route('company-setups.store') }}" method="POST" enctype="multipart/form-data" class="row g-3">
                @csrf

                <div class="col-12">
                    <label class="form-label">Company Name</label>
                    <input type="text" name="company_name" value="{{ old('company_name') }}"
                           class="form-control @error('company_name') is-invalid @enderror">
                    @error('company_name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" value="{{ old('email') }}"
                           class="form-control @error('email') is-invalid @enderror">
                    @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">Phone</label>
                    <input type="text" name="phone_number" value="{{ old('phone_number') }}"
                           class="form-control @error('phone_number') is-invalid @enderror">
                    @error('phone_number') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">WhatsApp</label>
                    <input type="text" name="whatsapp_number" value="{{ old('whatsapp_number') }}"
                           class="form-control @error('whatsapp_number') is-invalid @enderror">
                    @error('whatsapp_number') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">Telegram Link</label>
                    <input type="url" name="telegram_link" value="{{ old('telegram_link') }}"
                           class="form-control @error('telegram_link') is-invalid @enderror" placeholder="https://t.me/your_channel">
                    @error('telegram_link') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">Facebook Link</label>
                    <input type="url" name="facebook_link" value="{{ old('facebook_link') }}"
                           class="form-control @error('facebook_link') is-invalid @enderror" placeholder="https://facebook.com/your_page">
                    @error('facebook_link') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-12">
                    <label class="form-label">Address</label>
                    <input type="text" name="address" value="{{ old('address') }}"
                           class="form-control @error('address') is-invalid @enderror">
                    @error('address') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-12">
                    <label class="form-label">About Company</label>
                    <textarea name="about_company" rows="5"
                              class="form-control @error('about_company') is-invalid @enderror">{{ old('about_company') }}</textarea>
                    @error('about_company') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">Favicon (png/jpg/webp/ico, ≤2MB)</label>
                    <input type="file" name="fav_icon" accept="image/*"
                           class="form-control @error('fav_icon') is-invalid @enderror">
                    @error('fav_icon') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-md-6">
                    <label class="form-label">Logo (png/jpg/webp/svg, ≤4MB)</label>
                    <input type="file" name="logo" accept="image/*"
                           class="form-control @error('logo') is-invalid @enderror">
                    @error('logo') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="col-12 d-flex gap-2 pt-2">
                    <button class="btn btn-primary">Save</button>
                    <a href="{{ route('company-setups.index') }}" class="btn btn-light">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
