@extends('backend.master')
@section('title','Banks')

@section('content')
<div class="max-w-4xl mx-auto p-4 space-y-4">
  @if(session('success')) <div class="bg-emerald-50 text-emerald-700 p-2 rounded">{{ session('success') }}</div> @endif

  <form method="POST" action="{{ route('admin.banks.store') }}" class="bg-white p-4 rounded shadow space-y-3">
    @csrf
    <div class="grid md:grid-cols-4 gap-3">
      <input class="border rounded p-2" name="name" placeholder="Bank name" required>
      <input class="border rounded p-2" name="min_transaction" placeholder="Min amount" type="number" step="0.01" required>
      <input class="border rounded p-2" name="reward_percent" placeholder="Reward % (user)" type="number" step="0.01" required>
      <select name="is_active" class="border rounded p-2">
        <option value="1">Active</option><option value="0">Inactive</option>
      </select>
    </div>
    <button class="px-4 py-2 rounded bg-emerald-600 text-white">Save</button>
  </form>

  <div class="bg-white rounded shadow">
    <table class="min-w-full text-sm">
      <thead class="bg-gray-50">
        <tr>
          <th class="p-2 text-left">Bank</th>
          <th class="p-2 text-center">Min</th>
          <th class="p-2 text-center">Reward %</th>
          <th class="p-2 text-center">Active</th>
        </tr>
      </thead>
      <tbody>
        @foreach($banks as $b)
          <tr class="border-t">
            <td class="p-2">{{ $b->name }}</td>
            <td class="p-2 text-center">{{ number_format($b->min_transaction,0) }}</td>
            <td class="p-2 text-center">{{ $b->reward_percent }}%</td>
            <td class="p-2 text-center">{{ $b->is_active ? 'Yes' : 'No' }}</td>
          </tr>
        @endforeach
      </tbody>
    </table>
    <div class="p-2">{{ $banks->links() }}</div>
  </div>
</div>
@endsection
