@extends('backend.master')

@section('content')
<div class="container py-4">

    {{-- Flash success --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle-fill me-1"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    {{-- Header --}}
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h4 mb-0">
            <i class="bi bi-bank me-2"></i>Bank Methods
        </h1>
        <a href="{{ route('bank_methods.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle me-1"></i> Create
        </a>
    </div>

    {{-- Search --}}
    <form method="GET" action="{{ route('bank_methods.index') }}" class="mb-3">
        <div class="row g-2">
            <div class="col-md-6 col-lg-4">
                <div class="input-group">
                    <span class="input-group-text"><i class="bi bi-search"></i></span>
                    <input type="text" name="q" value="{{ request('q') }}" class="form-control" placeholder="Search by name / slug / account">
                    <button type="submit" class="btn btn-outline-secondary">Search</button>
                </div>
            </div>
        </div>
    </form>

    {{-- Table --}}
    <div class="card shadow-sm">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table align-middle mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Logo</th>
                            <th>Bank</th>
                            <th>Slug</th>
                            <th>Account</th>
                            <th>Holder</th>
                            <th class="text-nowrap">Daily Min / Max</th>
                            <th>Active</th>
                            <th>Order</th>
                            <th class="text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    @forelse($methods as $m)
                        <tr>
                            <td>{{ $m->id }}</td>
                            <td>
                                @if($m->bank_logo)
                                    <img src="{{ asset('storage/'.$m->bank_logo) }}" alt="logo" class="rounded border" style="height:32px;width:auto;">
                                @else
                                    <span class="text-muted">—</span>
                                @endif
                            </td>
                            <td class="fw-medium">{{ $m->bank_name }}</td>
                            <td><code class="text-muted">{{ $m->slug }}</code></td>
                            <td class="text-nowrap">{{ $m->account_number }}</td>
                            <td>{{ $m->account_holder }}</td>
                            <td class="text-nowrap">
                                <span class="badge bg-light text-dark">
                                    {{ $m->daily_min ?? '—' }} / {{ $m->daily_max ?? '—' }}
                                </span>
                            </td>
                            <td>
                                <form method="POST" action="{{ route('bank_methods.toggle', $m->id) }}">
                                    @csrf @method('PATCH')
                                    @if($m->is_active)
                                        <button type="submit" class="btn btn-sm btn-success" title="Click to deactivate">
                                            <i class="bi bi-check-circle me-1"></i> Active
                                        </button>
                                    @else
                                        <button type="submit" class="btn btn-sm btn-outline-secondary" title="Click to activate">
                                            <i class="bi bi-pause-circle me-1"></i> Inactive
                                        </button>
                                    @endif
                                </form>
                            </td>
                            <td>{{ $m->display_order }}</td>
                            <td class="text-end">
                                <div class="btn-group" role="group">
                                    <a href="{{ route('bank_methods.edit', $m->id) }}" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-pencil-square"></i> Edit
                                    </a>
                                    <form method="POST" action="{{ route('bank_methods.destroy', $m->id) }}"
                                          onsubmit="return confirm('Delete this method?');">
                                        @csrf @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger">
                                            <i class="bi bi-trash"></i> Delete
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="10" class="text-center py-4">
                                <i class="bi bi-inbox fs-3 d-block mb-2 text-muted"></i>
                                <div class="text-muted mb-2">No data found</div>
                                <a href="{{ route('bank_methods.create') }}" class="btn btn-sm btn-primary">
                                    <i class="bi bi-plus-circle me-1"></i> Create your first method
                                </a>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        @if($methods->hasPages())
            <div class="card-footer bg-white">
                {{ $methods->links() }}
            </div>
        @endif
    </div>
</div>
@endsection
