@extends('backend.master')

@section('content')
<div class="container py-4">
    {{-- Breadcrumbs --}}
    <nav aria-label="breadcrumb" class="mb-3">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="{{ route('bank_methods.index') }}">
                    <i class="bi bi-bank me-1"></i>Bank Methods
                </a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
                <i class="bi bi-pencil-square me-1"></i>Edit #{{ $method->id }}
            </li>
        </ol>
    </nav>

    {{-- Header --}}
    <div class="d-flex align-items-center justify-content-between mb-3">
        <h1 class="h4 mb-0">
            <i class="bi bi-buildings-fill me-2"></i>Edit Bank Method
            <span class="badge bg-{{ $method->is_active ? 'success' : 'secondary' }}">
                <i class="bi bi-{{ $method->is_active ? 'check-circle' : 'pause-circle' }} me-1"></i>
                {{ $method->is_active ? 'Active' : 'Inactive' }}
            </span>
        </h1>
        <a href="{{ route('bank_methods.index') }}" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-1"></i> Back to list
        </a>
    </div>

    {{-- Errors --}}
    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <div class="d-flex">
                <i class="bi bi-x-octagon-fill fs-4 me-2"></i>
                <div>
                    <strong>Validation failed:</strong>
                    <ul class="mb-0 mt-1">
                        @foreach ($errors->all() as $error) <li>{{ $error }}</li> @endforeach
                    </ul>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <form method="POST" action="{{ route('bank_methods.update', $method->id) }}" enctype="multipart/form-data" class="needs-validation" novalidate>
        @csrf @method('PUT')

        <div class="row g-4">
            {{-- Left column --}}
            <div class="col-lg-8">
                <div class="card shadow-sm">
                    <div class="card-header bg-white">
                        <i class="bi bi-info-circle me-1"></i> Basic Information
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-8">
                                <label class="form-label">
                                    <i class="bi bi-bank me-1"></i>Bank Name <span class="text-danger">*</span>
                                </label>
                                <input type="text"
                                       name="bank_name"
                                       value="{{ old('bank_name', $method->bank_name) }}"
                                       class="form-control @error('bank_name') is-invalid @enderror"
                                       required>
                                @error('bank_name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <div class="col-md-4">
                                <label class="form-label"><i class="bi bi-link-45deg me-1"></i>Slug</label>
                                <input type="text"
                                       name="slug"
                                       value="{{ old('slug', $method->slug) }}"
                                       class="form-control @error('slug') is-invalid @enderror">
                                @error('slug') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label"><i class="bi bi-123 me-1"></i>Account Number <span class="text-danger">*</span></label>
                                <input type="text"
                                       name="account_number"
                                       value="{{ old('account_number', $method->account_number) }}"
                                       class="form-control @error('account_number') is-invalid @enderror"
                                       required>
                                @error('account_number') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label"><i class="bi bi-person-badge me-1"></i>Account Holder <span class="text-danger">*</span></label>
                                <input type="text"
                                       name="account_holder"
                                       value="{{ old('account_holder', $method->account_holder) }}"
                                       class="form-control @error('account_holder') is-invalid @enderror"
                                       required>
                                @error('account_holder') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label"><i class="bi bi-geo-alt me-1"></i>Location</label>
                                <input type="text"
                                       name="location"
                                       value="{{ old('location', $method->location) }}"
                                       class="form-control @error('location') is-invalid @enderror"
                                       placeholder="Branch / City (optional)">
                                @error('location') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <div class="col-md-3">
                                <label class="form-label"><i class="bi bi-cash-coin me-1"></i>Daily Min</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-currency-dollar"></i></span>
                                    <input type="number"
                                           step="0.01" min="0"
                                           name="daily_min"
                                           value="{{ old('daily_min', $method->daily_min) }}"
                                           class="form-control @error('daily_min') is-invalid @enderror">
                                </div>
                                @error('daily_min') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="col-md-3">
                                <label class="form-label"><i class="bi bi-cash me-1"></i>Daily Max</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-currency-dollar"></i></span>
                                    <input type="number"
                                           step="0.01" min="0"
                                           name="daily_max"
                                           value="{{ old('daily_max', $method->daily_max) }}"
                                           class="form-control @error('daily_max') is-invalid @enderror">
                                </div>
                                @error('daily_max') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            </div>

                            <div class="col-12">
                                <label class="form-label"><i class="bi bi-braces-asterisk me-1"></i>Meta (JSON)</label>
                                <textarea name="meta_raw"
                                          rows="5"
                                          class="form-control font-monospace @error('meta_raw') is-invalid @enderror"
                                          placeholder='e.g. {"note":"xyz"}'>{{ old('meta_raw', $method->meta ? json_encode($method->meta, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES) : '') }}</textarea>
                                <div class="form-text">Optional JSON for extra configuration. Keep valid JSON.</div>
                                @error('meta_raw') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Right column --}}
            <div class="col-lg-4">
                {{-- Logo Card --}}
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <i class="bi bi-image me-1"></i> Bank Logo
                    </div>
                    <div class="card-body">
                        @if($method->bank_logo)
                            <div class="mb-3">
                                <div class="small text-muted mb-1">Current</div>
                                <div class="ratio ratio-16x9 bg-light border rounded overflow-hidden">
                                    <img src="{{ asset('storage/'.$method->bank_logo) }}" alt="logo" class="w-100 h-100 object-fit-contain">
                                </div>
                            </div>
                        @endif

                        <div class="mb-3">
                            <label class="form-label">Upload new (optional)</label>
                            <input class="form-control @error('bank_logo') is-invalid @enderror" type="file" name="bank_logo" accept="image/*" id="logoInput">
                            <div class="form-text">PNG/JPG/WebP up to 2MB. Uploading will replace existing logo.</div>
                            @error('bank_logo') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="ratio ratio-16x9 bg-light border rounded d-flex align-items-center justify-content-center overflow-hidden" id="logoPreviewWrap">
                            <img id="logoPreview" src="#" alt="Preview" class="d-none w-100 h-100 object-fit-contain">
                            <div id="logoPlaceholder" class="text-muted">
                                <i class="bi bi-image-alt fs-1 d-block mb-2"></i>
                                New logo preview will appear here
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Settings --}}
                <div class="card shadow-sm">
                    <div class="card-header bg-white">
                        <i class="bi bi-sliders me-1"></i> Settings
                    </div>
                    <div class="card-body">
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" type="checkbox" role="switch" id="isActiveSwitch" name="is_active" value="1" {{ old('is_active', $method->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="isActiveSwitch">
                                <i class="bi bi-power me-1 text-success"></i>Active
                            </label>
                        </div>

                        <label class="form-label"><i class="bi bi-sort-numeric-down me-1"></i>Display Order</label>
                        <input type="number"
                               min="0"
                               name="display_order"
                               value="{{ old('display_order', $method->display_order) }}"
                               class="form-control @error('display_order') is-invalid @enderror">
                        @error('display_order') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                </div>
            </div>
        </div>

        {{-- Actions --}}
        <div class="d-flex gap-2 mt-4">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save me-1"></i> Update Method
            </button>
            <a href="{{ route('bank_methods.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-x-circle me-1"></i> Back
            </a>
        </div>
    </form>
</div>

{{-- Image preview --}}
@push('scripts')
<script>
document.getElementById('logoInput')?.addEventListener('change', function (e) {
    const [file] = e.target.files || [];
    const img = document.getElementById('logoPreview');
    const ph  = document.getElementById('logoPlaceholder');
    if (file) {
        img.src = URL.createObjectURL(file);
        img.classList.remove('d-none');
        ph.classList.add('d-none');
    } else {
        img.src = '#';
        img.classList.add('d-none');
        ph.classList.remove('d-none');
    }
});
</script>
@endpush
@endsection
