    // Sidebar open/close
        const sidebar = document.getElementById('sidebar');
        document.getElementById('openSidebar').addEventListener('click', () => sidebar.classList.add('open'));
        document.getElementById('closeSidebar').addEventListener('click', () => sidebar.classList.remove('open'));

        // Balance slider (drag or tap to toggle)
        // const pill = document.getElementById('balancePill');
        // const knob = pill.querySelector('.knob');
        // const txt = document.getElementById('balanceText');
        // const details = document.getElementById('detailsBtn');

        // let drag = false,
        //     startX = 0,
        //     dragged = false;
        // let hideTimer = null; // <-- NEW: auto-hide timer

        // const clearHide = () => {
        //     if (hideTimer) {
        //         clearTimeout(hideTimer);
        //         hideTimer = null;
        //     }
        // };
        // const scheduleHide = () => {
        //     clearHide();
        //     hideTimer = setTimeout(() => activate(false), 3000); // <-- NEW: 3s auto hide
        // };

        // const activate = (on) => {
        //     pill.classList.toggle('active', on);
        //     txt.textContent = on ? '0 TK' : 'Check Balance';
        //     if (on) scheduleHide();
        //     else clearHide(); // <-- NEW: manage timer on state change
        // };
        // const toggle = () => activate(!pill.classList.contains('active'));

        const pill = document.getElementById('balancePill');
const knob = pill.querySelector('.knob');
const txt  = document.getElementById('balanceText');
const details = document.getElementById('detailsBtn');

const realBalance = txt.dataset.balance ?? '0.00'; // <-- Blade থেকে আসা টেক্সট

let drag=false, startX=0, dragged=false;
let hideTimer=null;

const clearHide = () => { if (hideTimer) { clearTimeout(hideTimer); hideTimer=null; } };
const scheduleHide = () => { clearHide(); hideTimer=setTimeout(()=>activate(false),3000); };

const activate = (on) => {
  pill.classList.toggle('active', on);
  // ✅ এখানে রিয়েল ব্যালেন্স দেখাচ্ছি
  txt.textContent = on ? `${realBalance} TK` : 'Check Balance';
  if (on) scheduleHide(); else clearHide();
};

const toggle = () => activate(!pill.classList.contains('active'));

// বাকি কোড অপরিবর্তিত…


        // tap/click toggle — ignore if a drag just happened
        pill.addEventListener('click', (e) => {
            if (e.target === details) return; // ignore details button
            if (dragged) {
                dragged = false;
                return;
            }
            toggle(); // activate() will schedule/clear timer itself
        });

        // drag handlers
        const onStart = (x) => {
            drag = true;
            startX = x;
            dragged = false;
            clearHide();
        };
        const onMove = (x) => {
            if (!drag) return;
            const moved = Math.abs(x - startX);
            if (moved > 3) dragged = true;

            const dx = Math.max(0, Math.min(1, (x - startX) / 80)); // 0..1
            knob.style.transform = `translateX(${dx*196}px)`;
        };
        const onEnd = (x) => {
            if (!drag) return;
            drag = false;
            knob.style.transform = '';
            const success = (x - startX) > 40;
            activate(success); // if turned on, auto-hide is scheduled for 3s
        };

        pill.addEventListener('touchstart', e => onStart(e.touches[0].clientX), {
            passive: true
        });
        pill.addEventListener('touchmove', e => onMove(e.touches[0].clientX), {
            passive: true
        });
        pill.addEventListener('touchend', e => onEnd(e.changedTouches[0].clientX));

        pill.addEventListener('mousedown', e => onStart(e.clientX));
        window.addEventListener('mousemove', e => onMove(e.clientX));
        window.addEventListener('mouseup', e => onEnd(e.clientX));

        // Details click (demo)
        details.addEventListener('click', () => alert('Balance details coming soon…'));





          var swiper = new Swiper(".mySwiper", {
                spaceBetween: 30,
                pagination: {
                    el: ".swiper-pagination",
                    clickable: true,
                },
            });



            