<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    public function run(): void
    {
        $pairs = [
            'deposit_banner_title'    => 'বিশেষ ডিপোজিট অফার',
            'deposit_banner_subtitle' => 'প্যাকেজ অনুযায়ী ডিপোজিট করলে আপনারা বেনিফিট পাবেন',
            'deposit_banner_chip'     => '% ৫% সরকারী বোনাস সহ',
            'deposit_rules_text'      => "কোম্পানির নীতিমালা অনুযায়ী ডিপোজিট করবেন। টাকা পাঠানোর আগে আপনার\nঅ্যাকাউন্ট ডিটেইলস যাচাই করে নিন। একাউন্টে জমা হতে কিছুক্ষণ সময় লাগতে পারে।",
            'contact_phone'           => '+8801XXXXXXXXX',
            'contact_provider'        => 'Remittance Pay',
        ];

        foreach ($pairs as $k => $v) {
            Setting::updateOrCreate(['key' => $k], ['value' => $v]);
        }
    }
}
