<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\PaymentMethod;

class PaymentMethodSeeder extends Seeder
{
    public function run(): void
    {
        $items = [
            ['name'=>'Bkash Personal','slug'=>'bkash-personal','type'=>'mobile_wallet','account_no'=>'01707311857','daily_min'=>500,'daily_max'=>500000],
            ['name'=>'Bkash & Nagad Personal','slug'=>'bkash-nagad-personal','type'=>'mobile_wallet','account_no'=>'01744924605','daily_min'=>500,'daily_max'=>500000],
            ['name'=>'Bkash Nagad & Rocket Personal','slug'=>'bkash-nagad-rocket-personal','type'=>'mobile_wallet','account_no'=>'01707311857','daily_min'=>500,'daily_max'=>500000],
            ['name'=>'official','slug'=>'official','type'=>'official','account_no'=>'16247','daily_min'=>0,'daily_max'=>10000],
        ];
        foreach ($items as $it) PaymentMethod::updateOrCreate(['slug'=>$it['slug']], $it);
    }
}
