<?php

// database/seeders/MobileGatewaySeeder.php
namespace Database\Seeders;

use App\Models\MobileGateway;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Storage;

class MobileGatewaySeeder extends Seeder
{
    public function run(): void
    {
        // public disk এ dummy svg লোগো তৈরি
        $disk   = Storage::disk('public');
        $folder = 'mobile-logos';
        if (! $disk->exists($folder)) {
            $disk->makeDirectory($folder);
        }

        $svgs = [
            'bkash.svg' => <<<SVG
<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128">
  <rect width="100%" height="100%" rx="24" fill="#F06292"/>
  <text x="50%" y="55%" dominant-baseline="middle" text-anchor="middle"
        font-family="Arial, Helvetica, sans-serif" font-size="48" fill="#fff" font-weight="700">B</text>
</svg>
SVG,
            'nagad.svg' => <<<SVG
<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128">
  <rect width="100%" height="100%" rx="24" fill="#FF7043"/>
  <text x="50%" y="55%" dominant-baseline="middle" text-anchor="middle"
        font-family="Arial, Helvetica, sans-serif" font-size="48" fill="#fff" font-weight="700">N</text>
</svg>
SVG,
            'rocket.svg' => <<<SVG
<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128">
  <rect width="100%" height="100%" rx="24" fill="#7E57C2"/>
  <text x="50%" y="55%" dominant-baseline="middle" text-anchor="middle"
        font-family="Arial, Helvetica, sans-serif" font-size="48" fill="#fff" font-weight="700">R</text>
</svg>
SVG,
        ];

        foreach ($svgs as $file => $svg) {
            $disk->put("$folder/$file", $svg);
        }

        // সিড ডেটা + লোগো পাথ
        $rows = [
            [
                'name' => 'Bkash', 'code' => 'BKASH',
                'min_limit' => 50, 'max_limit' => 500000,
                'flat_fee' => 0, 'percent_fee' => 1.0,
                'logo_path' => "storage/{$folder}/bkash.svg",
            ],
            [
                'name' => 'Nagad', 'code' => 'NAGAD',
                'min_limit' => 100, 'max_limit' => 400000,
                'flat_fee' => 0, 'percent_fee' => 0.8,
                'logo_path' => "storage/{$folder}/nagad.svg",
            ],
            [
                'name' => 'Rocket', 'code' => 'ROCKET',
                'min_limit' => 100, 'max_limit' => 600000,
                'flat_fee' => 0, 'percent_fee' => 0.9,
                'logo_path' => "storage/{$folder}/rocket.svg",
            ],
        ];

        foreach ($rows as $r) {
            MobileGateway::updateOrCreate(['code' => $r['code']], $r);
        }
    }
}
