<?php

// database/seeders/ExchangeCountrySeeder.php
namespace Database\Seeders;

use App\Models\ExchangeCountry;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class ExchangeCountrySeeder extends Seeder
{
    public function run(): void
    {
        $disk = Storage::disk('public');
        $dir  = 'flags';

        if (! $disk->exists($dir)) {
            $disk->makeDirectory($dir);
        }

        // FIX: closure now imports $disk and $dir via "use"
        $mk = function (string $file, string $bg, string $label) use ($disk, $dir): string {
            $svg = "<svg xmlns='http://www.w3.org/2000/svg' width='80' height='50'>
                        <rect width='100%' height='100%' rx='8' fill='{$bg}'/>
                        <text x='50%' y='60%' text-anchor='middle' font-size='18'
                              fill='#fff' font-family='Arial' font-weight='700'>{$label}</text>
                    </svg>";
            $disk->put("{$dir}/{$file}", $svg);
            return "storage/{$dir}/{$file}";
        };

        $rows = [
            ['Dubai',      'dirham',  '1 Dirham',  32.35,  '#136B5B', 'UAE'],
            ['Qatar',      'Rial',    '1 Rial',    38.55,  '#4C0519', 'QA'],
            ['Saudi Arab', 'Riyal',   '1 Riyal',   31.20,  '#065F46', 'SA'],
            ['Malaysia',   'Ringgit', '1 Ringgit', 34.60,  '#0C4A6E', 'MY'],
            ['Oman',       'Rial',    '1 Rial',   296.00,  '#7C2D12', 'OM'],
        ];

        foreach ($rows as [$name, $curr, $unit, $rate, $bg, $flag]) {
            ExchangeCountry::updateOrCreate(
                ['slug' => Str::slug($name)],
                [
                    'name'            => $name,
                    'currency_name'   => $curr,
                    'unit_label'      => $unit,
                    'rate_bdt'        => $rate,
                    'header_bg'       => $bg,
                    'flag_path'       => $mk(Str::slug($name) . '.svg', $bg, $flag),
                    'share_title_bn'  => 'ফলো এবং সাপোর্টের জন্য',
                    'share_desc_bn'   => 'আজকের রেট দেখুন এবং আমাদের স্পেশাল অফার ভিজিট করুন।',
                    'share_title_en'  => 'Follow us for updates',
                    'share_desc_en'   => 'Check the current rates and visit our special offers.',
                    'is_active'       => true,
                    'position'        => 0,
                ]
            );
        }
    }
}
