<?php

namespace Database\Seeders;

use App\Models\DepositPackage;
use Illuminate\Database\Seeder;

class DepositPackageSeeder extends Seeder
{
    public function run(): void
    {
        // Wipe & seed (safe for dev)
        DepositPackage::query()->delete();

        $rows = [
            [
                'title'            => '৫০,০০০ টাকা ডিপোজিট',
                'principal_amount' => 50000,
                'bonus_percent'    => 1.2,     // 1.2%
                'badge_text'       => '১.২%',
                'status'           => 'active',
                'sort_order'       => 10,
            ],
            [
                'title'            => '৯,২০০ টাকা ডিপোজিট',
                'principal_amount' => 9200,
                'bonus_percent'    => 2.5,
                'badge_text'       => '২.৫%',
                'status'           => 'active',
                'sort_order'       => 20,
            ],
            [
                'title'            => '৬১,৩০০ টাকা ডিপোজিট',
                'principal_amount' => 61300,
                'bonus_percent'    => 0.1,
                'badge_text'       => '০.১%',
                'status'           => 'active',
                'sort_order'       => 30,
            ],
            [
                'title'            => '৩,০০,০০০ টাকা ডিপোজিট',
                'principal_amount' => 300000,
                'bonus_percent'    => 1.0,
                'badge_text'       => '১%',
                'status'           => 'active',
                'sort_order'       => 40,
            ],
            [
                'title'            => '১,১০,২০০ টাকা ডিপোজিট',
                'principal_amount' => 110200,
                'bonus_percent'    => 0.2,
                'badge_text'       => '০.২%',
                'status'           => 'active',
                'sort_order'       => 50,
            ],
        ];

        foreach ($rows as $r) {
            // If badge missing, auto-generate like "1.2%"
            $r['badge_text'] = $r['badge_text'] ?: rtrim(rtrim(number_format($r['bonus_percent'], 2, '.', ''), '0'), '.') . '%';
            DepositPackage::create($r);
        }
    }
}
