<?php

namespace Database\Seeders;

use App\Models\Biller;
use App\Models\BillerCategory;
use Illuminate\Database\Seeder;

class BillerSeeder extends Seeder
{
    public function run(): void
    {
        // Ensure categories exist
        $power = BillerCategory::where('slug','power')->firstOrFail();
        $gas   = BillerCategory::where('slug','gas')->firstOrFail();
        $water = BillerCategory::where('slug','water')->firstOrFail();

        $billers = [
            // ---------- Power (Bidyut) ----------
            [
                'biller_category_id' => $power->id,
                'name'       => 'Palli Bidyut (Prepaid)',
                'code'       => 'BIDYUT_PALLI_PREPAID',
                'provider'   => 'BIDYUT',
                'type'       => 'prepaid',
                'logo'       => null,                 // put URL if you have one
                'min_amount' => 50,
                'max_amount' => 50000,
                'status'     => 'active',
                'sort_order' => 10,
            ],
            [
                'biller_category_id' => $power->id,
                'name'       => 'Palli Bidyut (Postpaid)',
                'code'       => 'BIDYUT_PALLI_POSTPAID',
                'provider'   => 'Bidyut',
                'type'       => 'postpaid',
                'logo'       => null,
                'min_amount' => 50,
                'max_amount' => 50000,
                'status'     => 'active',
                'sort_order' => 20,
            ],
            [
                'biller_category_id' => $power->id,
                'name'       => 'DESCO (Prepaid)',
                'code'       => 'DESCO_PREPAID',
                'provider'   => 'Bidyut',
                'type'       => 'prepaid',
                'logo'       => null,
                'min_amount' => 50,
                'max_amount' => 50000,
                'status'     => 'active',
                'sort_order' => 30,
            ],
            [
                'biller_category_id' => $power->id,
                'name'       => 'DESCO (Postpaid)',
                'code'       => 'DESCO_POSTPAID',
                'provider'   => 'Bidyut',
                'type'       => 'postpaid',
                'logo'       => null,
                'min_amount' => 50,
                'max_amount' => 50000,
                'status'     => 'active',
                'sort_order' => 40,
            ],
            [
                'biller_category_id' => $power->id,
                'name'       => 'NESCO (Prepaid)',
                'code'       => 'NESCO_PREPAID',
                'provider'   => 'Bidyut',
                'type'       => 'prepaid',
                'logo'       => null,
                'min_amount' => 50,
                'max_amount' => 50000,
                'status'     => 'active',
                'sort_order' => 50,
            ],
            [
                'biller_category_id' => $power->id,
                'name'       => 'NESCO (Postpaid)',
                'code'       => 'NESCO_POSTPAID',
                'provider'   => 'Bidyut',
                'type'       => 'postpaid',
                'logo'       => null,
                'min_amount' => 50,
                'max_amount' => 50000,
                'status'     => 'active',
                'sort_order' => 60,
            ],

            // ---------- Gas ----------
            [
                'biller_category_id' => $gas->id,
                'name'       => 'Titas Gas Postpaid (Non-Metered)',
                'code'       => 'TITAS_POSTPAID_NONMETERED',
                'provider'   => 'Gas',
                'type'       => 'postpaid',
                'logo'       => null,
                'min_amount' => 100,
                'max_amount' => 100000,
                'status'     => 'active',
                'sort_order' => 10,
            ],
            [
                'biller_category_id' => $gas->id,
                'name'       => 'Titas Gas Postpaid (Metered)',
                'code'       => 'TITAS_POSTPAID_METERED',
                'provider'   => 'Gas',
                'type'       => 'postpaid',
                'logo'       => null,
                'min_amount' => 100,
                'max_amount' => 100000,
                'status'     => 'active',
                'sort_order' => 20,
            ],
            [
                'biller_category_id' => $gas->id,
                'name'       => 'Karnaphuli Gas',
                'code'       => 'KARNAPHULI_GAS',
                'provider'   => 'Gas',
                'type'       => 'postpaid',
                'logo'       => null,
                'min_amount' => 100,
                'max_amount' => 100000,
                'status'     => 'active',
                'sort_order' => 30,
            ],

            // ---------- Water ----------
            [
                'biller_category_id' => $water->id,
                'name'       => 'Chattogram Wasa',
                'code'       => 'CTG_WASA',
                'provider'   => 'Water',
                'type'       => null,
                'logo'       => null,
                'min_amount' => 100,
                'max_amount' => 100000,
                'status'     => 'active',
                'sort_order' => 10,
            ],
            [
                'biller_category_id' => $water->id,
                'name'       => 'Rajshahi Wasa',
                'code'       => 'RAJSHAHI_WASA',
                'provider'   => 'Water',
                'type'       => null,
                'logo'       => null,
                'min_amount' => 100,
                'max_amount' => 100000,
                'status'     => 'active',
                'sort_order' => 20,
            ],
            [
                'biller_category_id' => $water->id,
                'name'       => 'Khulna Wasa',
                'code'       => 'KHULNA_WASA',
                'provider'   => 'Water',
                'type'       => null,
                'logo'       => null,
                'min_amount' => 100,
                'max_amount' => 100000,
                'status'     => 'active',
                'sort_order' => 30,
            ],
            [
                'biller_category_id' => $water->id,
                'name'       => 'Dhaka Wasa',
                'code'       => 'DHAKA_WASA',
                'provider'   => 'Water',
                'type'       => null,
                'logo'       => null,
                'min_amount' => 100,
                'max_amount' => 100000,
                'status'     => 'active',
                'sort_order' => 40,
            ],
        ];

        foreach ($billers as $b) {
            Biller::updateOrCreate(
                ['code' => $b['code']],
                $b
            );
        }
    }
}
