<?php

namespace Database\Seeders;

use App\Models\BillerCategory;
use Illuminate\Database\Seeder;

class BillerCategorySeeder extends Seeder
{
    public function run(): void
    {
        // You can safely re-run this; it won't duplicate rows thanks to updateOrCreate
        $rows = [
            [
                'slug'       => 'power',
                'name'       => 'Power',
                'icon'       => '⚡',
                'status'     => 'active',
                'sort_order' => 10,
            ],
            [
                'slug'       => 'gas',
                'name'       => 'Gas',
                'icon'       => '🔥',
                'status'     => 'active',
                'sort_order' => 20,
            ],
            [
                'slug'       => 'water',
                'name'       => 'Water',
                'icon'       => '💧',
                'status'     => 'active',
                'sort_order' => 30,
            ],
        ];

        foreach ($rows as $r) {
            BillerCategory::updateOrCreate(
                ['slug' => $r['slug']],
                $r
            );
        }
    }
}
