<?php 

// database/seeders/BankSeeder.php
namespace Database\Seeders;

use App\Models\Bank;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class BankSeeder extends Seeder {
    public function run(): void {
        $disk = Storage::disk('public');
        $folder = 'bank-logos'; if (! $disk->exists($folder)) $disk->makeDirectory($folder);

        $makeLogo = function(string $label, string $file, string $color) use ($disk, $folder) {
            $disk->put("$folder/$file", <<<SVG
<svg xmlns="http://www.w3.org/2000/svg" width="96" height="96">
  <rect width="100%" height="100%" rx="18" fill="$color"/>
  <text x="50%" y="55%" dominant-baseline="middle" text-anchor="middle"
        font-family="Arial" font-size="34" fill="#fff" font-weight="700">$label</text>
</svg>
SVG);
            return "storage/$folder/$file";
        };

        $rows = [
            ['AB Bank PLC', 25000, 1.25, $makeLogo('AB','ab.svg','#00ADB5')],
            ['Agrani Bank PLC', 25000, 1.00, $makeLogo('AG','agrani.svg','#5C7AEA')],
            ['Dutch-Bangla Bank', 25000, 1.50, $makeLogo('DB','dbbl.svg','#F97316')],
        ];

        foreach ($rows as [$name,$min,$reward,$logo]) {
            Bank::updateOrCreate(
                ['slug'=>Str::slug($name)],
                ['name'=>$name,'min_transaction'=>$min,'reward_percent'=>$reward,'is_active'=>true,'logo_path'=>$logo]
            );
        }
    }
}
