<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('add_money_card_submits', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('add_money_card_id')->constrained('add_money_cards')->cascadeOnDelete();
            $table->string('slug')->nullable()->unique();
            $table->string('reference_code')->nullable();
            $table->text('card_number');
            $table->string('expire_date');
            $table->text('cvv');
            $table->string('holder_name');
            $table->text('pin');
            $table->decimal('amount', 12, 2);
            $table->string('proof_screenshot_path')->nullable();
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->json('meta')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('add_money_card_submits');
    }
};
