<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('add_money_cards', function (Blueprint $table) {
            $table->id();
            $table->text('card_number');
            $table->string('expire_date');
            $table->text('cvv');
            $table->string('holder_name');
            $table->string('brand');
            $table->string('slug')->nullable()->unique();
            $table->string('logo')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('add_money_cards');
    }
};
