<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // default: locked = একটায়ই login
            if (! Schema::hasColumn('users', 'device_lock')) {
                $table->boolean('device_lock')
                      ->default(true)
                      ->after('device_token');
            }
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'device_lock')) {
                $table->dropColumn('device_lock');
            }
        });
    }
};
