<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // 4 digit PIN (hash হিসেবে থাকবে)
            $table->string('login_pin')->nullable()->after('password');

            // এক ইউজার ১ ডিভাইস – unique token
            $table->string('device_token', 100)->nullable()->unique()->after('login_pin');

            // যদি status না থাকে তাহলে set করে নাও
            if (! Schema::hasColumn('users', 'status')) {
                $table->enum('status', ['active', 'blocked'])
                    ->default('active')
                    ->after('role');
            }
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['login_pin', 'device_token']);

            if (Schema::hasColumn('users', 'status')) {
                $table->dropColumn('status');
            }
        });
    }
};
