<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('addmoney_bank_methods', function (Blueprint $table) {
            $table->id();
            $table->string('bank_name');
            $table->string('bank_logo')->nullable();
            $table->string('slug')->unique();
            $table->string('account_number');
            $table->string('account_holder');
            $table->string('location')->nullable();
            $table->decimal('daily_min', 12, 2)->nullable();
            $table->decimal('daily_max', 12, 2)->nullable();
            $table->boolean('is_active')->default(true)->index();
            $table->json('meta')->nullable();
            $table->unsignedInteger('display_order')->default(0)->index();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('addmoney_bank_methods');
    }
};
